/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#include <tqt.h>
#include <ntqmovie.h>

#ifdef USE_QT4

// TQMovie::TQMovie(QObject *parent) : QMovie(parent) {}
// TQMovie::TQMovie(QIODevice *device, const QByteArray &format, QObject *parent) : QMovie(device, format, parent) {}
// TQMovie::TQMovie(const QString &fileName, const QByteArray &format, QObject *parent) : QMovie(fileName, format, parent) {}

TQMovie::TQMovie(QObject *parent) {
	d = new QMovie(parent);
}

TQMovie::TQMovie(QIODevice *device, const QByteArray &format, QObject *parent) {
	d = new QMovie(device, format, parent);
}

TQMovie::TQMovie(const QString &fileName, const QByteArray &format, QObject *parent) {
	d = new QMovie(fileName, format, parent);
}

TQMovie::operator QMovie *() const {
	return d;
}

/*!
    Makes this movie use the same data as movie \a movie. QMovies use
    explicit sharing.
*/
TQMovie& TQMovie::operator=(const TQMovie& movie)
{
	d = movie.d;
	return *this;
}

#endif // USE_QT4
