"""
This template constructs an application with menus, toolbar and statusbar.
It uses KDE classes and methods that simplify the task of building and
operating a GUI. It is recommended that this approach be used, rather
than the primitive approach in menuapp1.py
"""

"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""


False = 0
True  = not False


import sys

from python_tqt.qt import TQPopupMenu, SIGNAL

from tdecore import TDEApplication, TDECmdLineArgs, TDEAboutData, i18n
from tdeui import TDEMainWindow, KMessageBox, KStdAction, TDEAction

STATUSBAR_LEFT   = 1
STATUSBAR_MIDDLE = 2
STATUSBAR_RIGHT  = 3

class MainWin (TDEMainWindow):
    def __init__ (self, *args):
        apply (TDEMainWindow.__init__, (self,) + args)

        # Create the actions that will populate
        # the menus and toolbars
        self.initActions ()

        # Plug actions into menus
        self.initMenus ()

        # Plug actions into toolbars
        self.initToolBar ()

        # Create the status bar
        self.initStatusBar ()

        # Usings actions, only a single line is required
        # to enable/disable both the menu item and corresponding
        # toolbar button from anywhere in the program
        self.saveAction.setEnabled (False)
        self.saveAsAction.setEnabled (False)

    def initActions (self):
        # Most of the functions selectable by menu are "standard"
        # actions (open a file, cut, paste, etc) - you customize
        # how they behave in your code, but menu, toolbar, and
        # accelerator settings are the same across all programs.
        # Standard actions also have tooltips already assigned

        # To create most of the actions below, KStdAction is
        # is used, since it takes care of everything with
        # a single line of code.

        # The standard actions only need to specify the slot
        # where the code for the action is located

        # "File" menu items
        self.newAction    = KStdAction.openNew (self.slotNew)
        self.openAction   = KStdAction.open (self.slotOpen)
        self.saveAction   = KStdAction.save (self.slotSave)
        self.saveAsAction = KStdAction.saveAs (self.slotSaveAs)
        self.printAction  = KStdAction.print_ (self.slotPrint)
        self.quitAction   = KStdAction.quit (self.slotQuit)

        # "Edit" menu items
        self.undoAction     = KStdAction.undo (self.slotUndo)
        self.redoAction     = KStdAction.redo (self.slotRedo)
        self.cutAction      = KStdAction.cut (self.slotCut)
        self.copyAction     = KStdAction.copy (self.slotCopy)
        self.pasteAction    = KStdAction.paste (self.slotPaste)
        self.findAction     = KStdAction.find (self.slotFind)
        self.findNextAction = KStdAction.findNext (self.slotFindNext)
        self.replaceAction  = KStdAction.replace (self.slotReplace)

        # For actions that are not "standard", you can create your
        # own actions using TDEAction. This example doesn't include
        # an icon, but there is a TDEAction constructor that will
        # allow you to specify an icon (for toolbar use, for instance),
        # or you can use TDEAction.setIcon to set/change the icon. You
        # can also add a tooltip with TDEAction.setToolTip

        # This TDEAction constructor requires a TQString, an accelerator (0
        # in this case), a slot, and a TQObject (None in this case)

        self.specialAction  = TDEAction (i18n ("Special"), 0, self.slotSpecial, None)

    def initMenus (self):
        # plug the actions into the menus

        fileMenu = TQPopupMenu (self)
        self.newAction.plug (fileMenu)
        self.openAction.plug (fileMenu)
        fileMenu.insertSeparator ()
        self.saveAction.plug (fileMenu)
        self.saveAsAction.plug (fileMenu)
        fileMenu.insertSeparator ()
        self.printAction.plug (fileMenu)
        fileMenu.insertSeparator ()
        self.quitAction.plug (fileMenu)
        self.menuBar ().insertItem (i18n ("&File"), fileMenu)

        editMenu = TQPopupMenu (self)
        self.undoAction.plug (editMenu)
        self.redoAction.plug (editMenu)
        editMenu.insertSeparator ()
        self.cutAction.plug (editMenu)
        self.copyAction.plug (editMenu)
        self.pasteAction.plug (editMenu)
        editMenu.insertSeparator ()
        self.findAction.plug (editMenu)
        self.findNextAction.plug (editMenu)
        self.replaceAction.plug (editMenu)
        editMenu.insertSeparator ()
        self.specialAction.plug (editMenu)
        self.menuBar ().insertItem (i18n ("&Edit"), editMenu)

        # Uses the info from TDEAboutData (specified below)
        # to construct the "About" box in the Help menu

        helpMenu = self.helpMenu ("")
        self.menuBar ().insertItem (i18n ("&Help"), helpMenu)

    def initToolBar (self):
        # Add some (but not all) actions to the toolbar

        self.newAction.plug (self.toolBar ())
        self.openAction.plug (self.toolBar ())
        self.saveAction.plug (self.toolBar ())
        self.cutAction.plug (self.toolBar ())
        self.copyAction.plug (self.toolBar ())
        self.pasteAction.plug (self.toolBar ())

    def initStatusBar (self):
        # Initialize the status bar

        self.statusBar ().insertItem ("", STATUSBAR_LEFT, 1000, True)
        self.statusBar ().insertItem ("", STATUSBAR_MIDDLE, 1000, True)
        self.statusBar ().insertItem ("", STATUSBAR_RIGHT, 1000, True)

#-------------------- slots -----------------------------------------------

    def slotNew (self, id = -1):
        self.notImpl ("New")

    def slotOpen(self, id = -1):
        self.notImpl ("Open")

    def slotSave (self, id = -1):
        self.notImpl ("Save")

    def slotSaveAs (self):
        self.notImpl ("Save As")

    def slotPrint (self):
        self.notImpl ("Print")

    def slotQuit (self):
        self.notImpl ("Quit")

    def slotUndo (self):
        self.notImpl ("Undo")

    def slotRedo (self):
        self.notImpl ("Redo")

    def slotCut (self, id = -1):
        self.notImpl ("Cut")

    def slotCopy (self, id = -1):
        self.notImpl ("Copy")

    def slotPaste (self, id = -1):
        self.notImpl ("Paste")

    def slotFind (self):
        self.notImpl ("Find")

    def slotFindNext (self):
        self.notImpl ("Find Next")

    def slotReplace (self):
        self.notImpl ("Replace")

    def slotSpecial (self):
        self.notImpl ("Special")

    def notImpl (self, item = "Feature"):
        self.statusBar ().changeItem ("%s not implemented" % item, STATUSBAR_LEFT)
        KMessageBox.error (self, "%s not implemented" % item, "Not Implemented")
        self.statusBar ().changeItem ("", STATUSBAR_LEFT)


#-------------------- main ------------------------------------------------

description = "A basic application template"
version     = "1.0"
aboutData   = TDEAboutData ("", "",\
    version, description, TDEAboutData.License_GPL,\
    "(C) 2003 whoever the author is")

aboutData.addAuthor ("author1", "whatever they did", "email@somedomain")
aboutData.addAuthor ("author2", "they did something else", "another@email.address")

TDECmdLineArgs.init (sys.argv, aboutData)

TDECmdLineArgs.addCmdLineOptions ([("+files", "File to open")])

app = TDEApplication ()
mainWindow = MainWin (None, "main window")
mainWindow.show()
app.exec_loop()
