iconName = 'stop'
labelText = 'KMessageBox'

from random import random
from traceback import print_exc
from StringIO import StringIO

from python_tqt.qt import TQFrame, TQGridLayout, TQLabel, TQStringList, SIGNAL
from tdecore import i18n
from tdeui import KGuiItem, KPushButton, KMessageBox, KTextEdit


helpText = ("The KMessageBox Python class wraps the static methods of its C++ "
            "counterpart.  Some of these methods are used below.  Refer to the "
            "docs for KMessageBox for a full list.")


class MainFrame(TQFrame):
    msg = 'Do you like food?'
    caption = 'Simple Question'
    err = 'Some kind of error happened, but it could be worse!'
    info = 'Always wash your hands after eating.'
    items = ['Apples', 'Bananas', 'Cantaloupe', 'Mangos', 'Oranges', 'Pears', ]

    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        items = TQStringList()
        for item in self.items:
            items.append(item)
        self.items = items

        responses = 'Ok Cancel Yes No Continue'.split()
        responses = [(getattr(KMessageBox, res), res) for res in responses]
        self.responses = dict(responses)

        self.help = KTextEdit(helpText, '', self)

        layout = TQGridLayout(self, 5, 2, 4) 
        layout.setRowStretch(0, 10)
        layout.setColStretch(1, 10)
        layout.addMultiCellWidget(self.help, 0, 1, 0, 1)

        button = KPushButton(i18n('Question Yes-No'), self)
        self.connect(button, SIGNAL('clicked()'), self.questionYesNo)
        layout.addWidget(button, 2, 0)
        layout.setRowStretch(2, 0)

        button = KPushButton(i18n('Warning Yes-No-Cancel'), self)
        self.connect(button, SIGNAL('clicked()'), self.warningYesNoCancel)
        layout.addWidget(button, 3, 0)
        layout.setRowStretch(3, 0)

        button = KPushButton(i18n('Warning Continue-Cancel-List'), self)
        self.connect(button, SIGNAL('clicked()'), self.warningContinueCancelList)
        layout.addWidget(button, 4, 0)
        layout.setRowStretch(4, 0)

        button = KPushButton(i18n('Error'), self)
        self.connect(button, SIGNAL('clicked()'), self.error)
        layout.addWidget(button, 5, 0)
        layout.setRowStretch(5, 0)

        button = KPushButton(i18n('Detailed Error'), self)
        self.connect(button, SIGNAL('clicked()'), self.detailedError)
        layout.addWidget(button, 6, 0)
        layout.setRowStretch(6, 0)

        button = KPushButton(i18n('Sorry'), self)
        self.connect(button, SIGNAL('clicked()'), self.sorry)
        layout.addWidget(button, 7, 0)
        layout.setRowStretch(7, 0)

        button = KPushButton(i18n('Detailed Sorry'), self)
        self.connect(button, SIGNAL('clicked()'), self.detailedSorry)
        layout.addWidget(button, 8, 0)
        layout.setRowStretch(8, 0)

        button = KPushButton(i18n('Information'), self)
        self.connect(button, SIGNAL('clicked()'), self.information)
        layout.addWidget(button, 9, 0)
        layout.setRowStretch(9, 0)

        button = KPushButton(i18n('Information List'), self)
        self.connect(button, SIGNAL('clicked()'), self.informationList)
        layout.addWidget(button, 10, 0)
        layout.setRowStretch(10, 0)

    def questionYesNo(self):
        dlg = KMessageBox.questionYesNo(self, self.msg, self.caption)
        print 'You pressed "%s"' % (self.responses.get(dlg, dlg), )

    def warningYesNoCancel(self):
        dlg = KMessageBox.warningYesNoCancel(self, self.msg, self.caption)
        print 'You pressed "%s"' % (self.responses.get(dlg, dlg), )

    def warningContinueCancelList(self):
        uiitem = KGuiItem('Time to Eat', 'favorites')
        ctor = KMessageBox.warningContinueCancelList
        dlgid = '%s' % random()
        args = self, self.msg, self.items, self.caption, uiitem, dlgid
        dlg = ctor(*args)
        print 'You pressed "%s"' % (self.responses.get(dlg, dlg), )

    def error(self):
        dlg = KMessageBox.error(self, self.err)
        print 'You pressed "%s"' % (self.responses.get(dlg, dlg), )

    def detailedError(self):
        try:
            x = self.thisAttributeDoesNotExist
        except (AttributeError, ), ex:
            handle = StringIO()
            print_exc(0, handle)
            details = handle.getvalue()
        dlg = KMessageBox.detailedError(self, self.err, details)
        print 'You pressed "%s"' % (self.responses.get(dlg, dlg), )

    def sorry(self):
        dlg = KMessageBox.sorry(self, self.err)
        print 'You pressed "%s"' % (self.responses.get(dlg, dlg), )

    def detailedSorry(self):
        try:
            x = self.thisAttributeDoesNotExist
        except (AttributeError, ), ex:
            handle = StringIO()
            print_exc(0, handle)
            details = handle.getvalue()
        dlg = KMessageBox.detailedSorry(self, self.err, details)
        print 'You pressed "%s"' % (self.responses.get(dlg, dlg), )

    def information(self):
        dlgid = '%s' % random()
        dlg = KMessageBox.information(self, self.info, '', dlgid)
        print 'You pressed "%s"' % (self.responses.get(dlg, dlg), )

    def informationList(self):
        dlgid = '%s' % random()
        ctor = KMessageBox.informationList
        dlg = ctor(self, self.info, self.items, '', dlgid)
        print 'You pressed "%s"' % (self.responses.get(dlg, dlg), )
