iconName = 'configure_shortcuts'
labelText = 'KKeyDialog'

from python_tqt.qt import TQFrame, TQHBoxLayout, TQVBoxLayout, SIGNAL
from tdecore import i18n
from tdeui import KPushButton, KKeyDialog, KTextEdit


helpText = ("Configuring keystroke shortcuts is simple with TDEActions and the "
            "KKeyDialog type.  This sample starts the KKeyDialog for the "
            "sampler application.")


class MainFrame(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Key Configuration Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        layout = TQVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = TQHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showKeysDialog)

    def showKeysDialog(self):
        top = self.topLevelWidget()
        KKeyDialog.configure(top.actionCollection(), self)
