iconName = 'editclear'
labelText = 'KInputDialog'

from python_tqt.qt import TQFrame, TQGridLayout, TQLabel, TQStringList, SIGNAL
from tdecore import i18n
from tdeui import KPushButton, KInputDialog, KTextEdit


helpText = ("KInputDialog allows the programmer to display a simple dialog to "
            "request a bit of text, an integer value, a double value, or a "
            "list item from the user.")


class MainFrame(TQFrame):
    items = ['Apples', 'Bananas', 'Mangos', 'Oranges', 'Pears', ]

    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.help = KTextEdit(helpText, '', self)

        layout = TQGridLayout(self, 5, 2, 4) # five rows, two cols, four px spacing
        layout.setRowStretch(0, 10)
        layout.setColStretch(1, 10)
        layout.addMultiCellWidget(self.help, 0, 1, 0, 1)

        button = KPushButton(i18n('Get Text'), self)
        self.connect(button, SIGNAL('clicked()'), self.getText)
        self.getTextLabel = TQLabel('text value', self)
        layout.addWidget(button, 2, 0)
        layout.addWidget(self.getTextLabel, 2, 1)
        layout.setRowStretch(2, 0)

        button = KPushButton(i18n('Get Integer'), self)
        self.connect(button, SIGNAL('clicked()'), self.getInt)
        self.getIntLabel = TQLabel('0', self)
        layout.addWidget(self.getIntLabel, 3, 1)
        layout.addWidget(button, 3, 0)
        layout.setRowStretch(3, 0)

        button = KPushButton(i18n('Get Double'), self)
        self.connect(button, SIGNAL('clicked()'), self.getDouble)
        self.getDoubleLabel = TQLabel('0.0', self)
        layout.addWidget(self.getDoubleLabel, 4, 1)
        layout.addWidget(button, 4, 0)
        layout.setRowStretch(4, 0)

        button = KPushButton(i18n('Get Item'), self)
        self.connect(button, SIGNAL('clicked()'), self.getItem)
        self.getItemLabel = TQLabel(self.items[0], self)
        layout.addWidget(button, 5, 0)
        layout.addWidget(self.getItemLabel, 5, 1)
        layout.setRowStretch(5, 0)

    def getText(self):
        title = 'KInputDialog.getText Dialog'
        label = 'Enter some text:'
        default = self.getTextLabel.text()
        value, accepted = KInputDialog.getText(title, label, default)
        if accepted:
            self.getTextLabel.setText(value)

    def getInt(self):
        title = 'KInputDialog.getInteger Dialog'
        label = 'Enter an integer:'
        default = int('%s' % self.getIntLabel.text())
        value, accepted = KInputDialog.getInteger(title, label, default)
        if accepted:
            self.getIntLabel.setText('%s' % value)

    def getDouble(self):
        title = 'KInputDialog.getDouble Dialog'
        label = 'Enter a double:'
        default = float('%s' % self.getDoubleLabel.text())
        value, accepted = KInputDialog.getDouble(title, label, default, -10.0, 10.0)
        if accepted:
            self.getDoubleLabel.setText('%s' % value)

    def getItem(self):
        title = 'KInputDialog.getItem Dialog'
        label = 'Select an item:'
        current = self.items.index('%s' % self.getItemLabel.text())
        selections = TQStringList()
        for item in self.items:
            selections.append(item)
        value, accepted = KInputDialog.getItem(title, label, selections, current)
        if accepted:
            self.getItemLabel.setText('%s' % value)
