#!/usr/bin/perl -w
use strict;
use blib;

package LCDRange;
use TQt;
use TQt::isa qw(TQt::VBox);

sub NEW {
    shift->SUPER::NEW(@_);

    my $lcd = TQt::LCDNumber(2, this, "lcd");
    my $slider = TQt::Slider(&Horizontal, this, "slider");
    $slider->setRange(0, 99);
    $slider->setValue(0);
    $lcd->connect($slider, TQT_SIGNAL('valueChanged(int)'), TQT_SLOT('display(int)'));
}

package MyWidget;
use TQt;
use TQt::isa qw(TQt::VBox);
use LCDRange;

sub NEW {
    shift->SUPER::NEW(@_);

    my $quit = TQt::PushButton("Quit", this, "quit");
    $quit->setFont(TQt::Font("Times", 18, &TQt::Font::Bold));

    TQt::app->connect($quit, TQT_SIGNAL('clicked()'), TQT_SLOT('quit()'));

    my $grid = TQt::Grid(4, this);

    for(0..3) {
	for(0..3) {
	    LCDRange($grid);
	}
    }
}

package main;
use MyWidget;

my $a = TQt::Application(\@ARGV);

my $w = MyWidget;
$a->setMainWidget($w);
$w->show;
exit $a->exec;
