/* ============================================================
 * File   : plugin.cpp
 * Authors: KIPI team developers (see AUTHORS files for details)
 *	    
 * Date   : 2004-02
 * Description :
 *
 * Copyright 2004 by the KIPI team
 * 
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * ============================================================ */

// TQt includes.
 
#include <tqwidget.h>

// KDE includes.

#include <tdeaction.h>
#include <kinstance.h>
#include <kdebug.h>

// Local includes.

#include "plugin.h"


struct KIPI::Plugin::Private {
    TQMap<TQWidget*, TDEActionCollection*> m_actionCollection;
    TDEInstance* m_instance;
    TQMap<TQWidget*, TDEActionPtrList> m_actions;
    TQWidget* m_defaultWidget;
};


KIPI::Plugin::Plugin( TDEInstance* instance, TQObject *parent, const char* name)
            : TQObject( parent, name)
{
    d=new Private;
    d->m_instance=instance;
}

KIPI::Plugin::~Plugin()
{
    delete d;
}

TDEActionCollection* KIPI::Plugin::actionCollection( TQWidget* widget )
{
    if ( widget == 0 )
        widget = d->m_defaultWidget;

    if (!d->m_actionCollection.contains( widget ))
        kdWarning( 51000 ) << "Error in the plugin. The plugin needs to call Plugin::setup( TQWidget* ) "
                           << "as the very first line when overriding the setup method." << endl;
    return d->m_actionCollection[widget];
}

void KIPI::Plugin::addAction( TDEAction* action )
{
    d->m_actions[d->m_defaultWidget].append( action );
}

TDEActionPtrList KIPI::Plugin::actions( TQWidget* widget )
{
    if ( widget == 0 )
        widget = d->m_defaultWidget;

    return d->m_actions[widget];
}

void KIPI::Plugin::setup( TQWidget* widget )
{
    d->m_defaultWidget = widget;
    d->m_actions.insert( widget, TDEActionPtrList() );
    TQString name = TQString( "action collection for %1" ).arg( widget->name() );
    d->m_actionCollection.insert( widget, new TDEActionCollection( widget, TQT_TQOBJECT(widget), name.latin1(), d->m_instance ) );
}



