//////////////////////////////////////////////////////////////////////////////
//
//    CHECKBINPROG.CPP
//
//    Copyright (C) 2003 Gilles CAULIER <caulier dot gilles at gmail dot com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Street, Fifth Floor, Cambridge, MA 02110-1301, USA.
//
//////////////////////////////////////////////////////////////////////////////

#include "checkbinprog.h"

// TQt includes

#include <tqwidget.h>
#include <tqdir.h>
#include <tqfile.h>
#include <tqfileinfo.h>

// KDElib includes

#include <tdelocale.h>
#include <tdeconfig.h>
#include <tdeapplication.h>
#include <kurl.h>
#include <tdemessagebox.h>
#include <kstandarddirs.h>

namespace KIPIMPEGEncoderPlugin
{

///////////////////////////////// CONSTRUCTOR ///////////////////////////////////////////////

CheckBinProg::CheckBinProg(TQObject *parent)
{
  config = new TDEConfig("kipirc");
  config->setGroup("MPEGEncoder Settings");
  ImageMagickPath = config->readPathEntry("ImageMagickBinFolder");
  MjpegToolsPath = config->readPathEntry("MjpegToolsBinFolder");
}


/////////////////////////////// DESTRUCTOR //////////////////////////////////////////////////

CheckBinProg::~CheckBinProg()
{
}


/////////////////////////////////////////////////////////////////////////////////////////////

int CheckBinProg::findExecutables( void )
{
  TQFile montage, composite, convert, identify, ppmtoy4m, yuvscaler, mpeg2enc, mp2enc, mplex;
  int ValRet = 0;

  if (ImageMagickPath.isEmpty())
        {
        KMessageBox::error(TQT_TQWIDGET(kapp->activeWindow()), i18n("Your 'ImageMagick' binary program path is empty.\nSetting to default value. Check option's setting."));
        return (ValRet);
        }

if (MjpegToolsPath.isEmpty())
        {
        KMessageBox::error(TQT_TQWIDGET(kapp->activeWindow()), i18n("Your 'MjpegTools' binary programs path is empty.\nSetting to default value. Check option's setting."));
        return (ValRet);
        }

  TQString str = "";

  // ImageMagick external programs.

  if (montage.exists(TQString (ImageMagickPath+"/montage")) == FALSE)
    str = i18n("Cannot find 'montage' binary program from ImageMagick package. Please install it.");

  if (composite.exists(TQString (ImageMagickPath+"/composite")) == FALSE)
    str = i18n("Cannot find 'composite' binary program from ImageMagick package. Please install it.");

  if (convert.exists(TQString (ImageMagickPath+"/convert")) == FALSE)
    str = i18n("Cannot find 'convert' binary program from ImageMagick package. Please install it.");

  if (identify.exists(TQString (ImageMagickPath+"/identify")) == FALSE)
    str = i18n("Cannot find 'identify' binary program from ImageMagick package. Please install it.");

  // MjpegTools external programs.

  if (ppmtoy4m.exists(TQString (MjpegToolsPath+"/ppmtoy4m")) == FALSE)
    str = i18n("Cannot find 'ppmtoy4m' binary program from MjpegTools package. Please install it.");

  if (yuvscaler.exists(TQString (MjpegToolsPath+"/yuvscaler")) == FALSE)
    str = i18n("Cannot find 'yuvscaler' binary program from MjpegTools package. Please install it.");

  if (mpeg2enc.exists(TQString (MjpegToolsPath+"/mpeg2enc")) == FALSE)
    str = i18n("Cannot find 'mpeg2enc' binary program from MjpegTools package. Please install it.");

  if (  mplex.exists(TQString (MjpegToolsPath+"/mplex")) == FALSE)
    str = i18n("Cannot find 'mplex' binary program from MjpegTools package. Please install it.");

  if (mp2enc.exists(TQString (MjpegToolsPath+"/mp2enc")) == FALSE)
    {
    str = i18n("Cannot find 'mp2enc' binary program from MjpegTools package. Please install it.\n"
               "Audio capabilities will be disabled.");
    ValRet = 2;
    }

  if ( !str.isEmpty() )
    {
    str += i18n("\nCheck your installation and this plugin's options settings."
                 "\n\nVisit these URLs for more information:"
                 "\nImageMagick package: http://www.imagemagick.org/"
                 "\nMjpegTools package: http://mjpeg.sourceforge.net/");
    KMessageBox::error(TQT_TQWIDGET(kapp->activeWindow()), str);
    return (ValRet);
    }

  return (1);
}

}  // NameSpace KIPIMPEGEncoderPlugin

#include "checkbinprog.moc"
