/* ============================================================
 * File  : cameraui.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-01-21
 * Description : 
 * 
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright 2004 by Tudor Calin <tudor@1xtech.com>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef CAMERAUI_H
#define CAMERAUI_H

// TQt includes.

#include <tqdict.h>
#include <tqstring.h>
#include <tqwidget.h>

// KDE includes.

#include <tdefileitem.h>

// Local includes.

#include "kpaboutdata.h"
#include "gpfileiteminfo.h"
#include "cameratype.h"

class TQComboBox;
class TQImage;
class TQLabel;
class TQLineEdit;
class TQPushButton;
class TQSplitter;

class TDEAccel;
class KComboBox;
class KDirLister;
class KProgress;
class KStatusBar;
class TDEToggleAction;



namespace TDEIO {
class Job;
}

namespace KIPIKameraKlientPlugin
{

class CameraList;
class CameraType;
class GPEventFilter;
class GPController;
class GPFileItemContainer;
class CameraIconItem;
class CameraIconView;
class CameraFolderItem;
class CameraFolderView;

class CameraUI : public TQWidget 
{
    Q_OBJECT
  

public:

    CameraUI();
    ~CameraUI();
    void setCameraConnected(bool val);
    const CameraType* cameraType();
    void setCameraType(const CameraType& ctype);
    void cameraInitialized(bool val);
    void cameraSubFolder(const TQString& folder, const TQString& subFolder);
    void cameraNewItems(const TQString& folder, const GPFileItemInfoList& infoList);
    void cameraNewItems(const GPFileItemInfoList& infoList);
    void cameraNewThumbnail(const TQString& folder, const TQString& itemName, const TQImage&  thumbnail);
    void cameraDownloadedItem(const TQString& folder, const TQString& itemName);
    void cameraDeletedItem(const TQString& folder, const TQString& itemName);
    void cameraErrorMsg(const TQString& msg);
   
private:

    void setupAccel();
    void setupConnections();
    bool cameraReadyForUpload(TQString& reason);
    void downloadOneItem(const TQString& item, const TQString& folder,
                         const TQString& downloadDir, bool& proceedFurther, bool& overwriteAll);
    
signals:

    void signalStatusMsg(const TQString&);
    void signalProgressVal(int);
    void signalBusy(bool);

public slots:

    void slotCameraConnectToggle();
    void slotCameraDownloadSelected();
    void slotCameraDeleteSelected();
    void slotCameraUpload();
    void slotCameraCancel();
    void slotSelectAll();
    void slotSelectNone();
    void slotSelectInvert();
    void slotSelectNew();
   
private slots:

    void slotSetStatusMsg(const TQString& msg);
    void slotSetProgressVal(int val);
    void slotResetStatusBar();
    void slotBusy(bool val);
    void slotSetupCamera();
    void slotSyncCameraComboBox();
    void slotFolderSelected(CameraFolderItem *item);
    void slotChangeDownloadDirectory();
    void writeSettings();
    void readSettings();
    void slotHelp();  
    
private:

    TQLabel              *mStatusLabel;
    
    KProgress           *mProgressBar;
    
    TQComboBox           *mCameraComboBox;
    
    TQPushButton         *mCameraConnectBtn;
    TQPushButton         *mCameraSetupBtn;
    TQPushButton         *mCameraStopBtn;
    TQPushButton         *mCameraDownloadBtn;
    TQPushButton         *mCameraUploadBtn;
    TQPushButton         *mCameraDeleteBtn;
    TQPushButton         *mDialogCloseBtn;
    TQPushButton         *mChangeDownloadDirectoryBtn;
    TQPushButton         *mhelpButton;

    TDEAccel              *mCameraUIAccel;
    
    TDEToggleAction       *mCameraConnectAction;
    
    CameraType          *mCameraType;
    
    CameraList       	*mCameraList;
    
    KStatusBar        	*mStatusBar;
    
    TDEConfig             *mConfig; 
    
    GPEventFilter       *efilter_;
    
    GPController        *controller_;
    
    GPFileItemContainer *container_;
    
    TQSplitter           *mSplitter;   
    
    CameraFolderView    *mFolderView;
    
    CameraIconView      *mIconView;
    
    TQString             cameraPath_;
    
    bool                cameraConnected_;
    
    TQLineEdit           *mDownloadDirectoryEdit;

    KIPIPlugins::KPAboutData    *m_about;
};

}  // NameSpace KIPIKameraKlientPlugin

#endif 
