/* ============================================================
 * File  : camerafolderview.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-01-23
 * Description : 
 * 
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef CAMERAFOLDERVIEW_H
#define CAMERAFOLDERVIEW_H

// TQt
#include <tqstring.h>
// KDE
#include <tdelistview.h>

namespace KIPIKameraKlientPlugin
{

class CameraFolderItem;

class CameraFolderView : public TDEListView {
    Q_OBJECT
  

public:
    CameraFolderView(TQWidget* parent);
    ~CameraFolderView();
    void addVirtualFolder(const TQString& name);
    void addRootFolder(const TQString& folder);
    CameraFolderItem* addFolder(const TQString& folder, const TQString& subFolder);
    CameraFolderItem* findFolder(const TQString& folderPath);
    CameraFolderItem* virtualFolder();
    CameraFolderItem* rootFolder();
    virtual void clear();
    
private:
    TQString cameraName_;
    CameraFolderItem *virtualFolder_;
    CameraFolderItem *rootFolder_;

private:
    void setupConnections();
    
private slots:
    void slotSelectionChanged(TQListViewItem* item);

signals:
    void signalFolderChanged(CameraFolderItem*);
    void signalCleared();
};

}  // NameSpace KIPIKameraKlientPlugin

#endif

