/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2003-10-14
 * Description : batch image flip
 *
 * Copyright (C) 2004-2007 by Marcel Wiesweg <marcel dot wiesweg at gmx dot de>
 * Copyright (C) 2003-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef IMAGEFLIP_H
#define IMAGEFLIP_H

// Local includes.

#include "actions.h"

// TQt includes.

#include <tqobject.h>
#include <tqstring.h>

class KTempFile;
class TDEProcess;

namespace KIPIJPEGLossLessPlugin
{

class ImageFlip : public TQObject
{
    Q_OBJECT
  

public:

    ImageFlip();
    ~ImageFlip();

    bool flip(const TQString& src, FlipAction action, TQString& err);

private slots:

    void slotReadStderr(TDEProcess*, char*, int);

private:

    bool flipJPEG(const TQString& src, const TQString& dest, FlipAction action, TQString& err);
    bool flipImageMagick(const TQString& src, const TQString& dest, FlipAction action, TQString& err);

private:

    TQString    m_stdErr;

    KTempFile *m_tmpFile;
};

}  // NameSpace KIPIJPEGLossLessPlugin

#endif /* IMAGEFLIP_H */
