/*
A KIPI plugin to generate HTML image galleries
Copyright 2006 by Aurelien Gateau <aurelien dot gateau at free.fr>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Cambridge, MA 02110-1301, USA.

*/
// Self
#include "galleryinfo.h"

// TQt

// KDE
#include <tdeconfigbase.h>

// Local

namespace KIPIHTMLExport {

static const char* THEME_GROUP_PREFIX="Theme ";

TQString GalleryInfo::getThemeParameterValue(
	const TQString& theme,
	const TQString& parameter,
	const TQString& defaultValue) const
{
	TQString groupName = THEME_GROUP_PREFIX + theme;
	TDEConfigGroupSaver saver(config(), groupName);
	return config()->readEntry(parameter, defaultValue);
}


void GalleryInfo::setThemeParameterValue(
	const TQString& theme,
	const TQString& parameter,
	const TQString& value)
{
	// FIXME: This is hackish, but config() is const :'(
	TDEConfig* localConfig = const_cast<TDEConfig*>(config());

	TQString groupName = THEME_GROUP_PREFIX + theme;
	TDEConfigGroupSaver saver(localConfig, groupName);
	return localConfig->writeEntry(parameter, value);
}



} // namespace
