#!/usr/bin/env python

# TQt tutorial 6.

import sys
from python_tqt import qt


class LCDRange(qt.TQVBox):
    def __init__(self, parent=None, name=None):
        qt.TQVBox.__init__(self, parent, name)

        lcd = qt.TQLCDNumber(2, self, "lcd")
        slider = qt.TQSlider(qt.TQt.Horizontal, self, "slider")
        slider.setRange(0, 99)
        slider.setValue(0)
        self.connect(slider, qt.SIGNAL("valueChanged(int)"), lcd, qt.SLOT("display(int)"))


class MyWidget(qt.TQVBox):
    def __init__(self, parent=None, name=None):
        qt.TQVBox.__init__(self, parent, name)

        quit = qt.TQPushButton("Quit", self, "quit")
        quit.setFont(qt.TQFont("Times", 18, qt.TQFont.Bold))

        self.connect(quit, qt.SIGNAL("clicked()"), qt.tqApp, qt.SLOT("quit()"))

        grid = qt.TQGrid(4, self)

        for c in range(4):
            for r in range(4):
                LCDRange(grid)


a = qt.TQApplication(sys.argv)

w = MyWidget()
a.setMainWidget(w)
w.show()
sys.exit(a.exec_loop())
