#!/usr/bin/env python

import sys
from python_tqt.qt import *
from python_tqt.qtsql import *

from frmconnect import frmConnect
from dbpar import *

TRUE  = 1
FALSE = 0

def createConnection():
    driver = DB_DRIVER
    # all qt examples use TQSqlDatabase::addDatabase, but
    # this never returns NULL in my experience
    drivers = list(map(str, TQSqlDatabase.drivers()))
    if driver in drivers:
        dlg = dbConnect(driver)
        #TODO: make connection parameters accessible
        return dlg.exec_loop()
    else:
        TQMessageBox.warning(None, "Database Error",
            "<%s> database driver not found!\n\n"
            "Please make sure, that this database adaptor\n"
            "is available in your TQt installation.\n" % 
            (driver), TQMessageBox.Abort | TQMessageBox.Escape)
        return FALSE

class dbConnect(frmConnect):
    def __init__(self, driver, parent = None):
        frmConnect.__init__(self, parent)
        self.hostnames = DB_HOSTNAMES
        self.hostname = DB_HOSTNAMES[0]
        self.databases = DB_DATABASES
        self.database = DB_DATABASES[0]
        self.username = DB_USERNAME
        self.password = DB_PASSWORD
        self.dbdriver = driver

        self.txtName.setText(self.username)
        self.txtPasswd.setText(self.password)
        list(map(self.cmbServer.insertItem, self.hostnames))
        list(map(self.cmbDatabase.insertItem, self.databases))
        self.connect(self.buttonHelp, SIGNAL("clicked()"),
                     self.buttonHelp_clicked)

    def accept(self):
        self.hostname = self.cmbServer.currentText()
        self.database = self.cmbDatabase.currentText()
        self.username = self.txtName.text()
        self.password = self.txtPasswd.text()
        db = TQSqlDatabase.addDatabase(self.dbdriver)
        if db:
            db.setHostName(self.hostname)
            db.setDatabaseName(self.database)
            db.setUserName(self.username)
            db.setPassword(self.password)
            if db.open():
                frmConnect.accept(self)
            else:
                TQMessageBox.warning(self, "Database Error",
                    "Cannot open %s database on %s!\n\n%s\n%s\n" %
                    (self.database, self.hostname,
                    db.lastError().driverText(),
                    db.lastError().databaseText()), " Ooops ")


    def buttonHelp_clicked(self):
        TQMessageBox.information(self, "About Connecting",
            "Here you specify userid, password, host and database\n"
            "for the PyTQt sql examples. If you encounter any problems,\n"
            "please read the README file in this folder before posting.\n\n"
            "Thanks,\nHans-Peter Jansen <hpj@urpla.net>\n")


if __name__ == "__main__":
    app = TQApplication(sys.argv)
    if createConnection():
        print("ok")
    else:
        print("cancel")
