/***************************************************************************
                          tagaction.h  -  description
                             -------------------
    begin                : ?
    copyright            : (C) ? Dmitry Poplavsky
                           (C) 2002-2005 Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TAGACTION_H
#define TAGACTION_H

#include <tdeversion.h>
#include <tdeaction.h>
#include <tdeactioncollection.h>

#include <tqstring.h>
#include <tqdom.h>

class TDEMainWindow;
class QuantaView;
class TDEProcess;
class TQDomElement;
class TQFile;
class TQTimer;
class MessageOutput;
class Node;
class NodeModifsSet;
class NodeSelection;

/**
 * An action for inserting an XML tag.
 *
 * @author Dmitry Poplavsky, dima@kde.org
 *         Andras Mantia, amantia@kde.org
 *         Paulo Moura Guedes, moura@kdewebdev.org
 */

class TagAction : public TDEToggleAction
{
    Q_OBJECT
  

public:
    /**
     * Create an insert from dom element.
     * @param toggle If set to true, the class behaves like a TDEToggleAction;
     *               Else it behaves like a TDEAction. This avoids the multi-inheritance problem.
     */
    TagAction(TQDomElement *element, TDEMainWindow *parentMainWindow, bool toggle = false);
    virtual ~TagAction();

    TQDomElement data() const { return tag; }
    void setModified(bool modified) { m_modified = modified;}
    bool isModified() const {return m_modified;}
    void setOutputFile(TQFile* file);
    void setInputFileName(const TQString& fileName);
    void addArguments(const TQStringList& arguments);
    bool toggable() const {return tag.attribute("toggable") == "true";}
    bool toggled() const {return isChecked();}
    
    /** Activates the action.
      @param blocking in case of script actions, the script is run in blocking mode, if this argument is true
    */
    void execute(bool blocking);
    TQString type();
    /**
     * Remove accelerator from tag action name *
     */
    TQString actionText();

    TQString XMLTagName() const;
    TQString openXMLTagString() const;
    TQString closeXMLTagString() const;

signals:
    void showMessage(const TQString& msg, bool append);
    void clearMessages();
    void showMessagesView();
    void createNewFile();

public slots:
    virtual void slotActivated();
    
    /**
     * We need this information in order to know if queued actions should be applied.
     * It's public because it can be activated by other classes if there are any queued actions.
     */
    virtual bool slotActionActivated(TDEAction::ActivationReason reason, TQt::ButtonState state);

protected slots:
    virtual void slotGetScriptOutput( TDEProcess *, char *buffer, int buflen );
    virtual void slotGetScriptError( TDEProcess *, char *buffer, int buflen );
    virtual void scriptDone();
    void slotTimeout();
    void slotProcessExited(TDEProcess *);
    virtual bool slotActionActivated();

private:
    void applyTagInSelection(Node* start_node, int start_offset, Node* end_node, int end_offset, 
                             NodeSelection& selection, NodeModifsSet* modifs) const;
    void applyTagInMixedSelection(Node* start_node, int start_offset, Node* end_node, int end_offset, 
                                  NodeSelection& selection, NodeModifsSet* modifs) const;
    void deapplyTagInSelection(Node* start_node, int start_offset, Node* end_node, int end_offset, 
                               NodeSelection& selection, NodeModifsSet* modifs) const;
    void deapplyTagInMixedSelection(Node* start_node, int start_offset, Node* end_node, int end_offset, 
                                    NodeSelection& selection, NodeModifsSet* modifs) const;
    
private:
    TDEProcess *proc;
    bool firstError;
    bool firstOutput;
    bool m_modified;
    bool loopStarted;
    bool m_useInputFile;
    bool m_useOutputFile;
    TQString scriptOutputDest;
    TQString scriptErrorDest;
    TQTimer* timer;
    TQDomElement tag;
    TQFile* m_file;
    TDEMainWindow *m_parentMainWindow;
    TQString m_inputFileName;
    TQStringList m_argsList;
    uint m_killCount;
    bool const m_toggle;
};


#endif // TAGACTION_H
