/***************************************************************************
                             tagattributetree.h
                             -------------------
    copyright            : (C) 2003 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef TAGATTRIBUTETREE_H
#define TAGATTRIBUTETREE_H

//qt includes
#include <tqwidget.h>

//kde includes
#include <tdelistview.h>

//app includes

class TDEListView;
class TQListViewItem;
class ParentItem;
class Node;
class TQLabel;
class KPushButton;
class TQGridLayout;

class EditableTree : public TDEListView {
Q_OBJECT
  

public:
  EditableTree(TQWidget *parent = 0, const char *name = 0);
  virtual ~EditableTree();

  virtual void setCurrentItem( TQListViewItem *i);
  void setEditable(bool b) {m_editable = b;}
  bool isEditable() {return m_editable;}

public slots:
  virtual void editorContentChanged();
  virtual void focusInEvent(TQFocusEvent *);
  virtual void focusOutEvent(TQFocusEvent *);

protected:
  bool m_editable;

};

class DualEditableTree : public EditableTree
{
  Q_OBJECT
  
public:
  DualEditableTree(TQWidget *parent = 0, const char *name = 0);
  virtual ~DualEditableTree();

  virtual void setCurrentItem ( TQListViewItem *i);
  int currentColumn() {return curCol;}

protected:
  virtual bool eventFilter(TQObject *object, TQEvent *event);
  virtual void resizeEvent(TQResizeEvent *);

signals:
  void itemModified( TQListViewItem *);

public slots:
  virtual void editorContentChanged();

private slots:
  void itemClicked(TQListViewItem *i, const TQPoint &point, int col);

private:
  int curCol;
};

class TagAttributeTree : public EditableTree  {
   Q_OBJECT
  

public:
  TagAttributeTree(TQWidget *parent=0, const char *name=0);
  virtual ~TagAttributeTree();

  void setCurrentNode(Node *node);
  //virtual void setCurrentItem( TQListViewItem *i );
  Node *node() const {return m_node;}

public slots:
  void slotDelayedSetCurrentNode();
  void slotParentSelected(int index);
  virtual void editorContentChanged();

private slots:
  void slotCollapsed(TQListViewItem *item);
  void slotExpanded(TQListViewItem *item);

signals:
  void newNodeSelected(Node *node);

private:
  Node *m_node;
  Node *m_newNode;
  bool rebuildEnabled;
  ParentItem *m_parentItem;
};

//An enhanced TagAttributeTree with the tag name and buttons to delete the tag.
class EnhancedTagAttributeTree : public TQWidget
{
Q_OBJECT
  
public:
  EnhancedTagAttributeTree(TQWidget *parent = 0, const char *name = 0);
  virtual ~EnhancedTagAttributeTree();

  void setCurrentNode(Node *node);
  Node *node() const {return attrTree->node();}

signals:
  void newNodeSelected(Node *node);

private slots:
  void NodeSelected(Node *node);
  void deleteNode();
  void deleteSubTree();

private:
  void showCaption();

  TQLabel *nodeName;
  KPushButton* deleteAll;
  KPushButton* deleteTag;
  TagAttributeTree *attrTree;
  TQGridLayout *widgetLayout;
  Node *curNode;
};

#endif

