/***************************************************************************
                          areaattributedb.h  -  description
                             -------------------
    begin                : gio mar 20 2003
    copyright            : (C) 2003 by gulmini luciano
    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AREAATTRIBUTEDB_H
#define AREAATTRIBUTEDB_H
#include <tqrect.h>
#include <tqmap.h>
#include <tqobject.h>
/**this is
  *@author gulmini luciano
  */

class areaAttribute : public TQObject{
    Q_OBJECT
  

    private:
      TQRect m_geometry;
      TQMap<TQString,TQString> m_attributeMap;     //tag specific attributes

    public:
      areaAttribute();
      ~areaAttribute(){};
      void setAttribute(const TQString& name, const TQString& value){ m_attributeMap[name] = value; }
      void setAllAttributes(TQMap<TQString,TQString> map){ m_attributeMap = map; }
      void resetAttributes();
      TQRect geometry() const { return m_geometry; }
      TQString src() const{ return m_attributeMap["src"]; }
      TQString attributeValue(TQString l) const { return attributeMap()[l];}
      TQMap<TQString,TQString> attributeMap() const { return m_attributeMap; }

    public slots:
      void setGeometry(TQRect g) { m_geometry = g; }
};

#endif
