/***************************************************************************
                          colorslider.cpp  -  description
                             -------------------
    begin                : lun  ago 9 2004
    copyright            : (C) 2004 by gulmini luciano
    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqvbox.h>
#include <tqlabel.h>

#include <tdelocale.h>

#include "colorslider.h"
#include "propertysetter.h"

/**
  *@author gulmini luciano
  */

  

colorSlider::colorSlider(const TQString& fn,const TQString& l,const TQString& c,const TQString& r,TQWidget *parent, const char *name) : miniEditor(parent,name)  { 
  m_functionName = fn;
  TQVBox *leftBox = new TQVBox(this);
  TQVBox *centerBox = new TQVBox(this);
  TQVBox *rightBox = new TQVBox(this);
  TQLabel *leftLabel = new TQLabel("<b>" +  l +"</b>",leftBox);
  TQLabel *centerLabel = new TQLabel(("<b>" +  c +"</b>"),centerBox);
  TQLabel *rightLabel = new TQLabel(("<b>" +  r +"</b>"),rightBox);
  leftLabel->setAlignment(TQt::AlignHCenter);
  centerLabel->setAlignment(TQt::AlignHCenter);
  rightLabel->setAlignment(TQt::AlignHCenter);  
  leftLabel->setTextFormat (TQt::RichText ) ;
  centerLabel->setTextFormat ( TQt::RichText ) ;
  rightLabel->setTextFormat (TQt::RichText  ) ;
  m_leftValue = new TQSlider ( 0, 255, 1, 0, Qt::Horizontal , leftBox);
  m_centerValue = new TQSlider ( 0, 255, 1, 0, Qt::Horizontal , centerBox);
  m_rightValue = new TQSlider ( 0, 255, 1, 0, Qt::Horizontal , rightBox);
  setSpacing(10);
  connect(m_leftValue, TQT_SIGNAL(valueChanged ( int)), this, TQT_SLOT(convertLeftValue(int)));
  connect(m_centerValue, TQT_SIGNAL(valueChanged ( int)), this, TQT_SLOT(convertCenterValue(int)));
  connect(m_rightValue, TQT_SIGNAL(valueChanged ( int)), this, TQT_SLOT(convertRightValue(int)));
}

colorSlider::~colorSlider(){
  //delete m_redValue;
  //delete m_greenValue;
  //delete m_blueValue; 
}

void colorSlider::connectToPropertySetter(propertySetter* p){
  connect( this, TQT_SIGNAL(valueChanged(const TQString&)), p, TQT_SIGNAL(valueChanged(const TQString&)));
}

void colorSlider::convertLeftValue(int i){
  emit valueChanged(m_functionName + "(" + TQString::number(i,10) + "," + TQString::number(m_centerValue->value(),10) + "," +TQString::number(m_rightValue->value(),10) +")");
}

void colorSlider::convertCenterValue(int i){
  emit valueChanged(m_functionName + "(" +  TQString::number(m_leftValue->value(),10) + "," + TQString::number(i,10) + "," + TQString::number(m_rightValue->value(),10) +")");
}

void colorSlider::convertRightValue(int i){
  emit valueChanged(m_functionName + "(" + TQString::number(m_leftValue->value(),10) + "," + TQString::number(m_centerValue->value(),10) + "," + TQString::number(i,10) +")");
}

RGBcolorSlider::RGBcolorSlider(TQWidget *parent, const char *name) : colorSlider("rgb",i18n("Red"),i18n("Green"),i18n("Blue"),parent,name){
}

//FOR CSS3
/*HSLcolorSlider::HSLcolorSlider(TQWidget *parent, const char *name) : colorSlider("hsl",i18n("Hue"),i18n("Saturation"),i18n("Lightness"),parent,name){
}
*/

#include "colorslider.moc"
