/***************************************************************************
                          xsldbgbreakpointsimpl.cpp  -  description
                             -------------------
    begin                : Fri Jan 4 2002
    copyright            : (C) 2002 by Keith Isdale
    email                : k_isdale@tpg.com.au
 ***************************************************************************/

/***********************************************************************************
 *                                                                         										*
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                   							*
 *                                                                         										*
 ************************************************************************************/

#include <tdelocale.h>
#include <tqlistview.h>
#include <tqlineedit.h>
#include <tqmessagebox.h>
#include "xsldbgdebugger.h"
#include "xsldbgbreakpointsimpl.h"
#include "xsldbgbreakpointlistitem.h"
#include <kdebug.h> 


XsldbgBreakpointsImpl::XsldbgBreakpointsImpl(XsldbgDebugger *debugger,
	TQWidget *parent /*=0*/, const char *name /*=0*/)
		:  XsldbgBreakpoints(parent, name), XsldbgDialogBase()
{
	this->debugger = debugger;
	connect(debugger, TQT_SIGNAL(breakpointItem(TQString /* file*/,
                         int /*line number */, TQString /*templateName*/,
                         TQString /* modeName*/,
	                 bool /* enabled */, int /* id */)),
		this, TQT_SLOT(slotProcBreakpointItem(TQString /* file*/,
			 int /*line number */, TQString /*templateName*/,
			 TQString /* modeName */,
			 bool /* enabled */, int /* id */)));
	connect( breakpointListView,  TQT_SIGNAL(selectionChanged(TQListViewItem *)),
						this, TQT_SLOT(selectionChanged(TQListViewItem*)));
	show();
	refresh();
}

XsldbgBreakpointsImpl::~XsldbgBreakpointsImpl()
{
    debugger = 0L;
}

int XsldbgBreakpointsImpl::getLineNumber()
{
	bool isOk = false;
	int lineNo = lineNumberEdit->text().toInt(&isOk);
	if (isOk == false){
		lineNo = -1;
		kdDebug() << "Invalid line number" << endl;
	}

	return lineNo;
}

int XsldbgBreakpointsImpl::getId()
{
	bool isOk = false;
	int id = idEdit->text().toInt(&isOk);
	if (isOk == false){
		id = -1;
		kdDebug() << "Invalid line number" << endl;
	}

	return id;
}

void XsldbgBreakpointsImpl::slotAddBreakpoint()
{
	int lineNo = getLineNumber();
	if (lineNo != -1) {
	  if (!sourceFileEdit->text().isEmpty()){
	        debugger->slotBreakCmd(sourceFileEdit->text(), lineNo);
	  }else {
	      TQMessageBox::information(this, i18n("Operation Failed"),
		  i18n("A line number was provided without a file name."),
  	           TQMessageBox::Ok);
	  }
	}else if (!templateNameEdit->text().isEmpty() ||
		  !modeNameEdit->text().isEmpty()){
		debugger->slotBreakCmd(templateNameEdit->text(),
				       modeNameEdit->text());
	}else{
	    TQMessageBox::information(this, i18n("Operation Failed"),
		 i18n("No details provided or an invalid line number was supplied."),
  	          TQMessageBox::Ok);
	}
}

void  XsldbgBreakpointsImpl::slotAddAllTemplateBreakpoints()
{
  if (debugger != 0L){
    debugger->fakeInput("break *", true);
    debugger->fakeInput("show", true);
  }
}

void XsldbgBreakpointsImpl::slotDeleteBreakpoint()
{
	int lineNo = getLineNumber(), id = getId();
	if (id != -1){
		debugger->slotDeleteCmd(id);
	}else if (lineNo != -1) {
	  if (!sourceFileEdit->text().isEmpty()){
		debugger->slotDeleteCmd(sourceFileEdit->text(), lineNo);
	  }else {
	    TQMessageBox::information(this, i18n("Operation Failed"),
	         i18n("A line number was provided without a file name."),
  	         TQMessageBox::Ok);
	  }
	}else {
	    TQMessageBox::information(this, i18n("Operation Failed"),
		 i18n("No details provided or an invalid line or ID was supplied."),
  	          TQMessageBox::Ok);
	}
}

void  XsldbgBreakpointsImpl::slotDeleteAllBreakpoints()
{
  if (debugger != 0L){
    debugger->fakeInput("delete *", true);
    debugger->fakeInput("show", true);
  }
}

void XsldbgBreakpointsImpl::slotEnableBreakpoint()
{
	int lineNo = getLineNumber(), id = getId();
	if (id != -1){
		debugger->slotEnableCmd(id);
	}else if (lineNo != -1){
	  if (!sourceFileEdit->text().isEmpty()){
		debugger->slotEnableCmd(sourceFileEdit->text(), lineNo);
	  }else {
	       TQMessageBox::information(this, i18n("Operation Failed"),
	           i18n("A line number was provided without a file name."),
  	           TQMessageBox::Ok);
	  }
	}else {
	    TQMessageBox::information(this, i18n("Operation Failed"),
		 i18n("No details provided."),
  	          TQMessageBox::Ok);
	}
}

void XsldbgBreakpointsImpl::selectionChanged(TQListViewItem *item)
{
	XsldbgBreakpointListItem *breakItem =
	       dynamic_cast<XsldbgBreakpointListItem*>(item);
	if (breakItem){
	  idEdit->setText(TQString::number(breakItem->getId()));
	  templateNameEdit->setText(breakItem->getTemplateName());
	  modeNameEdit->setText(breakItem->getModeName());
	  sourceFileEdit->setText(breakItem->getFileName());
	  lineNumberEdit->setText(TQString::number(breakItem->getLineNumber()));		}
}


void XsldbgBreakpointsImpl::refresh()
{
	/* get xsldbg to tell what breakpoints are set,
	   we'll get the notification back via slotProcBreakpointItem */
	debugger->fakeInput("showbreak", true);
}


void XsldbgBreakpointsImpl::slotClear()
{
	idEdit->setText("");
	templateNameEdit->setText("");
	modeNameEdit->setText("");
 	sourceFileEdit->setText("");
 	lineNumberEdit->setText("");
}

void XsldbgBreakpointsImpl::slotProcBreakpointItem(TQString  fileName,
						   int lineNumber ,
						   TQString templateName,
						   TQString modeName,
						   bool enabled, int id )
{
	if (fileName.isNull())
		  breakpointListView->clear();
	else{
	  breakpointListView->insertItem(
	       new XsldbgBreakpointListItem(breakpointListView,
	       fileName, lineNumber,templateName, modeName, enabled, id));
	}
}




#include "xsldbgbreakpointsimpl.moc"
