/***************************************************************************
                          timer.h - Widget for running scripts periodically
                             -------------------
    copyright            : (C) 2004 Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 **************************************************************************/
#ifndef _HAVE_TIMER_H_
#define _HAVE_TIMER_H_

/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqlabel.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>

class TQTimer;
class KOMMANDER_EXPORT Timer : public TQLabel, public KommanderWidget
{
  Q_OBJECT
  

  TQ_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  TQ_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  TQ_PROPERTY(bool KommanderWidget READ isKommanderWidget)
  TQ_PROPERTY(int interval READ interval WRITE setInterval)
  TQ_PROPERTY(bool singleShot READ singleShot WRITE setSingleShot)

  public:
    Timer(TQWidget *a_parent, const char *a_name);
    ~Timer();

    virtual bool isKommanderWidget() const;
    virtual void setAssociatedText(const TQStringList&);
    virtual TQStringList associatedText() const;
    virtual TQString currentState() const;
    virtual TQString populationText() const;
    virtual void setPopulationText(const TQString&);
    virtual int interval() const;
    virtual void setInterval(int a_interval);
    virtual bool singleShot() const;
    virtual void setSingleShot(bool a_shot);
    virtual TQString handleDCOP(int function, const TQStringList& args);
    virtual bool isFunctionSupported(int function);
  public slots:
    virtual void setWidgetText(const TQString &);
    virtual void populate();
    virtual void execute();
    virtual void cancel(); 
  protected slots:
    virtual void timeout();
  signals:
    void finished();

  protected:
    virtual void executeProcess(bool blocking);
    TQTimer* mTimer;
    int mInterval;
    bool mSingleShot;
  
};

#endif
