/***************************************************************************
                         statusbar.cpp - StatusBar widget 
                             -------------------
    copyright            : (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqobject.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tqevent.h>

/* OTHER INCLUDES */
#include <specials.h>
#include "statusbar.h"

StatusBar::StatusBar(TQWidget *a_parent, const char *a_name)
  : KStatusBar(a_parent, a_name), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
  insertItem(TQString(), 0, 1);
  setItemAlignment(0, TQt::AlignLeft);
}

StatusBar::~StatusBar()
{
}

TQString StatusBar::currentState() const
{
  return TQString("default");
}

bool StatusBar::isKommanderWidget() const
{
  return true;
}

TQStringList StatusBar::associatedText() const
{
  return KommanderWidget::associatedText();
}

void StatusBar::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void StatusBar::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString StatusBar::populationText() const
{
  return KommanderWidget::populationText();
}

void StatusBar::populate()
{
  changeItem(KommanderWidget::evalAssociatedText(populationText()), 0);
}

void StatusBar::showEvent(TQShowEvent *e)
{
  TQStatusBar::showEvent(e);
  emit widgetOpened();
}

void StatusBar::contextMenuEvent( TQContextMenuEvent * e )
{
  e->accept();
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}

bool StatusBar::isFunctionSupported(int f)
{
  return f == DCOP::setText || f == DCOP::insertItem || f == DCOP::removeItem || f == DCOP::clear || f == DCOP::getBackgroundColor || f == DCOP::setBackgroundColor;
}

TQString StatusBar::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::setText:
      changeItem(args[0], 0);
      break;
    case DCOP::insertItem:
      if (hasItem(args[1].toInt()))
        changeItem(args[0], args[1].toInt());
      else 
        insertItem(args[0], args[1].toInt());
      break;
    case DCOP::removeItem:
      removeItem(args[0].toInt());
      break;
    case DCOP::clear:
      clear();
      break;
    case DCOP::getBackgroundColor:
      return this->paletteBackgroundColor().name();
      break;
    case DCOP::setBackgroundColor:
    {
      TQColor color;
      color.setNamedColor(args[0]);
      this->setPaletteBackgroundColor(color);
      break;
    }
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}

#include "statusbar.moc"
