 /**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef TIMESTAMP_H
#define TIMESTAMP_H

#include <tqobject.h>
#include <tqdatetime.h>
#include <tqtimer.h>

class TimeStamp : public TQObject
{
    Q_OBJECT
  

public:
    TimeStamp( TQObject *parent, const TQString &f );

    void setFileName( const TQString &f );
    TQString fileName() const;
    void setAutoCheckEnabled( bool a );
    void update();

    bool isUpToDate() const;
    bool isAutoCheckEnabled() const;

signals:
    void timeStampChanged();

private slots:
    void autoCheckTimeStamp();

private:
    TQDateTime lastTimeStamp;
    TQString filename;
    bool autoCheck;
    TQTimer *timer;

};

#endif
