/***************************************************************************
                          kimedialogs.cpp  -  description
                            -------------------
    begin                : Tue Apr 17 2001
    copyright            : (C) 2001 by Jan Sch�er
    email                : j_schaef@informatik.uni-kl.de
***************************************************************************/

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

// QT
//#include <tqstring.h>
#include <tqcheckbox.h>
#include <tqmultilineedit.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqhbox.h>
#include <tqvbox.h>
#include <tqlineedit.h>
#include <tqlistbox.h>
#include <tqtable.h>
#include <tqgroupbox.h>
#include <tqspinbox.h>
#include <tqtabwidget.h>
#include <tqpointarray.h>
#include <tqimage.h>
//#include <tqwidget.h>
// KDE
#include <kiconloader.h>
#include <tdefiledialog.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <tdeapplication.h>
#include <tdehtmlview.h>
#include <tdehtml_part.h>
#include <tdetempfile.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>

// LOCAL
#include "kimedialogs.h"

CoordsEdit::CoordsEdit(TQWidget *parent, Area* a)
  : TQWidget(parent)
{
  area=a;
}

void CoordsEdit::applyChanges() {
  return;
}

void CoordsEdit::slotTriggerUpdate() {
  applyChanges();
  emit update();
}

CoordsEdit::~CoordsEdit()
{
}

RectCoordsEdit::RectCoordsEdit(TQWidget *parent, Area* a)
  : CoordsEdit(parent,a)
{
  TQGridLayout *layout= new TQGridLayout(this,5,2,5,5);

  topXSpin = new TQSpinBox(this);
  topXSpin->setMaxValue(INT_MAX);
  topXSpin->setMinValue(0);
  topXSpin->setValue(a->rect().left());
  layout->addWidget(topXSpin,0,1);
  connect( topXSpin, TQT_SIGNAL(valueChanged(const TQString &)), this, TQT_SLOT(slotTriggerUpdate()));

  TQLabel *lbl= new TQLabel(i18n("Top &X:"),this);
  lbl->setBuddy(topXSpin);
  layout->addWidget(lbl,0,0);

  topYSpin = new TQSpinBox(this);
  topYSpin->setMaxValue(INT_MAX);
  topYSpin->setMinValue(0);
  topYSpin->setValue(a->rect().top());
  layout->addWidget(topYSpin,1,1);
  connect( topYSpin, TQT_SIGNAL(valueChanged(const TQString &)), this, TQT_SLOT(slotTriggerUpdate()));

  lbl= new TQLabel(i18n("Top &Y:"),this);
  lbl->setBuddy(topYSpin);
  layout->addWidget(lbl,1,0);

  widthSpin = new TQSpinBox(this);
  widthSpin->setMaxValue(INT_MAX);
  widthSpin->setMinValue(0);
  widthSpin->setValue(a->rect().width());
  layout->addWidget(widthSpin,2,1);
  connect( widthSpin, TQT_SIGNAL(valueChanged(const TQString &)), this, TQT_SLOT(slotTriggerUpdate()));

  lbl= new TQLabel(i18n("&Width:"),this);
  lbl->setBuddy(widthSpin);
  layout->addWidget(lbl,2,0);

  heightSpin = new TQSpinBox(this);
  heightSpin->setMaxValue(INT_MAX);
  heightSpin->setMinValue(0);
  heightSpin->setValue(a->rect().height());
  layout->addWidget(heightSpin,3,1);
  connect( heightSpin, TQT_SIGNAL(valueChanged(const TQString &)), this, TQT_SLOT(slotTriggerUpdate()));

  lbl= new TQLabel(i18n("Hei&ght:"),this);
  lbl->setBuddy(heightSpin);
  layout->addWidget(lbl,3,0);

  layout->setRowStretch(4,10);
}

void RectCoordsEdit::applyChanges() {
  TQRect r;
  r.setLeft(topXSpin->text().toInt());
  r.setTop(topYSpin->text().toInt());
  r.setWidth(widthSpin->text().toInt());
  r.setHeight(heightSpin->text().toInt());
  area->setRect(r);
}

CircleCoordsEdit::CircleCoordsEdit(TQWidget *parent, Area* a)
  : CoordsEdit(parent,a)
{
  TQGridLayout *layout= new TQGridLayout(this,4,2,5,5);

  centerXSpin = new TQSpinBox(this);
  centerXSpin->setMaxValue(INT_MAX);
  centerXSpin->setMinValue(0);
  centerXSpin->setValue(a->rect().center().x());
  layout->addWidget(centerXSpin,0,1);
  connect( centerXSpin, TQT_SIGNAL(valueChanged(const TQString &)), this, TQT_SLOT(slotTriggerUpdate()));

  TQLabel *lbl= new TQLabel(i18n("Center &X:"),this);
  lbl->setBuddy(centerXSpin);
  layout->addWidget(lbl,0,0);

  centerYSpin = new TQSpinBox(this);
  centerYSpin->setMaxValue(INT_MAX);
  centerYSpin->setMinValue(0);
  centerYSpin->setValue(a->rect().center().y());
  layout->addWidget(centerYSpin,1,1);
  connect( centerYSpin, TQT_SIGNAL(valueChanged(const TQString &)), this, TQT_SLOT(slotTriggerUpdate()));


  lbl= new TQLabel(i18n("Center &Y:"),this);
  lbl->setBuddy(centerYSpin);
  layout->addWidget(lbl,1,0);

  radiusSpin = new TQSpinBox(this);
  radiusSpin->setMaxValue(INT_MAX);
  radiusSpin->setMinValue(0);
  radiusSpin->setValue(a->rect().width()/2);
  layout->addWidget(radiusSpin,2,1);
  connect( radiusSpin, TQT_SIGNAL(valueChanged(const TQString &)), this, TQT_SLOT(slotTriggerUpdate()));


  lbl= new TQLabel(i18n("&Radius:"),this);
  lbl->setBuddy(radiusSpin);
  layout->addWidget(lbl,2,0);

  layout->setRowStretch(3,10);

}

void CircleCoordsEdit::applyChanges() {
  TQRect r;
  r.setWidth(radiusSpin->text().toInt()*2);
  r.setHeight(radiusSpin->text().toInt()*2);
  r.moveCenter(TQPoint(centerXSpin->text().toInt(),
                      centerYSpin->text().toInt()));
  area->setRect(r);
}

PolyCoordsEdit::PolyCoordsEdit(TQWidget *parent, Area* a)
  : CoordsEdit(parent,a)
{
  if (!a) return;
  TQVBoxLayout *layout= new TQVBoxLayout(this);
  int numPoints=a->coords()->count();
  coordsTable= new TQTable(numPoints,2,this);
  coordsTable->horizontalHeader()->setLabel(0,"X");
  coordsTable->horizontalHeader()->setLabel(1,"Y");
  coordsTable->verticalHeader()->hide();
  coordsTable->setLeftMargin(0);
  coordsTable->setSelectionMode( TQTable::Single );


  for (int i=0;i<numPoints;i++) {
    coordsTable->setText(i,0, TQString::number(area->coords()->point(i).x()) );
    coordsTable->setText(i,1, TQString::number(area->coords()->point(i).y()) );
  }

  connect( coordsTable, TQT_SIGNAL(currentChanged(int,int)), this, TQT_SLOT(slotHighlightPoint(int)));

//	coordsTable->setMinimumHeight(50);
//	coordsTable->setMaximumHeight(400);
//	coordsTable->resizeContents(100,100);
  coordsTable->resize(coordsTable->width(),100);
  layout->addWidget(coordsTable);
  layout->setStretchFactor(coordsTable,-1);
  TQHBox *hbox= new TQHBox(this);
  TQPushButton *addBtn=new TQPushButton(i18n("Add"),hbox);
  connect( addBtn, TQT_SIGNAL(pressed()), this, TQT_SLOT(slotAddPoint()));
  TQPushButton *removeBtn=new TQPushButton(i18n("Remove"),hbox);
  connect( removeBtn, TQT_SIGNAL(pressed()), this, TQT_SLOT(slotRemovePoint()));

  layout->addWidget(hbox);
  slotHighlightPoint(1);
}

PolyCoordsEdit::~PolyCoordsEdit() {
  if (area)
    area->highlightSelectionPoint(-1);
}

void PolyCoordsEdit::slotHighlightPoint(int row) {
  if (!area) return;
  area->highlightSelectionPoint(row);
  emit update();
}


void PolyCoordsEdit::slotAddPoint() {
  int newPos= coordsTable->currentRow();
  TQPoint currentPoint=area->coords()->point(newPos);
  area->insertCoord(newPos,currentPoint);

  int count=area->coords()->size();

  coordsTable->setNumRows(count);

  for (int i=0;i<count;i++) {
    coordsTable->setText(i,0, TQString::number(area->coords()->point(i).x()) );
    coordsTable->setText(i,1, TQString::number(area->coords()->point(i).y()) );
  }

  emit update();
}

void PolyCoordsEdit::slotRemovePoint() {
  int currentPos= coordsTable->currentRow();

  area->removeCoord(currentPos);

  int count=area->coords()->size();

  coordsTable->setNumRows(count);

  for (int i=0;i<count;i++) {
    coordsTable->setText(i,0, TQString::number(area->coords()->point(i).x()) );
    coordsTable->setText(i,1, TQString::number(area->coords()->point(i).y()) );
  }

  emit update();
}

void PolyCoordsEdit::applyChanges() {
  int count=coordsTable->numRows();

  for (int i=0;i<count;i++) {
    TQPoint newPoint( coordsTable->text(i,0).toInt(),
                    coordsTable->text(i,1).toInt());

    area->moveCoord(i,newPoint);
  }
}

SelectionCoordsEdit::SelectionCoordsEdit(TQWidget *parent, Area* a)
  : CoordsEdit(parent,a)
{
  TQGridLayout *layout= new TQGridLayout(this,2,2);

  topXSpin = new TQSpinBox(this);
  topXSpin->setMaxValue(INT_MAX);
  topXSpin->setMinValue(0);
  topXSpin->setValue(a->rect().left());
  layout->addWidget(topXSpin,0,1);
  connect( topXSpin, TQT_SIGNAL(valueChanged(const TQString &)), this, TQT_SLOT(slotTriggerUpdate()));

  TQLabel *lbl= new TQLabel(i18n("Top &X"),this);
  lbl->setBuddy(topXSpin);
  layout->addWidget(lbl,0,0);

  topYSpin = new TQSpinBox(this);
  topYSpin->setMaxValue(INT_MAX);
  topYSpin->setMinValue(0);
  topYSpin->setValue(a->rect().top());
  layout->addWidget(topYSpin,1,1);
  connect( topYSpin, TQT_SIGNAL(valueChanged(const TQString &)), this, TQT_SLOT(slotTriggerUpdate()));

  lbl= new TQLabel(i18n("Top &Y"),this);
  lbl->setBuddy(topYSpin);
  layout->addWidget(lbl,1,0);
}

void SelectionCoordsEdit::applyChanges() {
  area->moveTo(topXSpin->text().toInt(), topYSpin->text().toInt());
}



TQLineEdit* AreaDialog::createLineEdit(TQWidget* parent, TQGridLayout *layout, int y, const TQString & value, const TQString & name)
{
  TQLineEdit* edit=new TQLineEdit(value,parent);
  layout->addWidget(edit,y,2);
  TQLabel* lbl=new TQLabel(name,parent);
  lbl->setBuddy(edit);
  layout->addWidget(lbl,y,1);

  return edit;
}

TQWidget* AreaDialog::createGeneralPage()
{
  TQFrame* page = new TQFrame(this);
  TQGridLayout* layout = new TQGridLayout(page,5,2,5,5);


  TQHBox *hbox= new TQHBox(page);
  hrefEdit = new TQLineEdit(area->attribute("href"),hbox);
  TQPushButton *btn = new TQPushButton("",hbox);
  btn->setPixmap(SmallIcon("document-open"));
  connect( btn, TQT_SIGNAL(pressed()), this, TQT_SLOT(slotChooseHref()));
  hbox->setMinimumHeight(hbox->height());

  layout->addWidget(hbox,0,2);
  TQLabel *lbl=new TQLabel(i18n( "&HREF:" ),page);
  lbl->setBuddy(hrefEdit);
  layout->addWidget(lbl,0,1);

  altEdit = createLineEdit(page,layout,1,area->attribute("alt"),i18n("Alt. &Text:"));
  targetEdit = createLineEdit(page,layout,2,area->attribute("target"),i18n("Tar&get:"));
  titleEdit = createLineEdit(page,layout,3,area->attribute("title"),i18n("Tit&le:"));

  if (area->type()==Area::Default)
  {
    defaultAreaChk = new TQCheckBox(i18n("Enable default map"),page);
    if (area->finished())
      defaultAreaChk->setChecked(true);
    layout->addWidget(defaultAreaChk,3,2);
  }


  layout->setRowStretch(4,10);

  return page;
}

TQWidget* AreaDialog::createCoordsPage()
{
  TQFrame* page = new TQFrame(this);
  TQVBoxLayout *layout = new TQVBoxLayout(page);
  layout->setMargin(5);

  coordsEdit = createCoordsEdit(page,area);
  layout->addWidget(coordsEdit);
  connect( coordsEdit, TQT_SIGNAL(update()), this, TQT_SLOT(slotUpdateArea()));

  return page;
}

TQWidget* AreaDialog::createJavascriptPage()
{
  TQFrame* page = new TQFrame(this);
  TQGridLayout* layout = new TQGridLayout(page,8,2,5,5);

  onClickEdit = createLineEdit(page,layout,0,area->attribute("onClick"),i18n("OnClick:"));
  onDblClickEdit = createLineEdit(page,layout,1,area->attribute("onDblClick"),i18n("OnDblClick:"));
  onMouseDownEdit = createLineEdit(page,layout,2,area->attribute("onMouseDown"),i18n("OnMouseDown:"));
  onMouseUpEdit = createLineEdit(page,layout,3,area->attribute("onMouseUp"),i18n("OnMouseUp:"));
  onMouseOverEdit = createLineEdit(page,layout,4,area->attribute("onMouseOver"),i18n("OnMouseOver:"));
  onMouseMoveEdit = createLineEdit(page,layout,5,area->attribute("onMouseMove"),i18n("OnMouseMove:"));
  onMouseOutEdit = createLineEdit(page,layout,6,area->attribute("onMouseOut"),i18n("OnMouseOut:"));

  layout->setRowStretch(7,10);


  return page;
}

TQWidget* AreaDialog::createButtonBar()
{
  TQHBox *box = new TQHBox(this);
  TQWidget *spacer = new TQWidget(box);
  TQPushButton *okBtn = new KPushButton(KStdGuiItem::ok(),box);
  TQPushButton *applyBtn = new KPushButton(KStdGuiItem::apply(),box);
  TQPushButton *cancelBtn = new KPushButton(KStdGuiItem::cancel(),box);

  connect(okBtn, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotOk()));
  connect(applyBtn, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotApply()));
  connect(cancelBtn, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotCancel()));

  box->setSpacing(5);
  box->setStretchFactor(spacer,10);

  okBtn->setDefault(true);

  return box;

}

AreaDialog::AreaDialog(KImageMapEditor* parent,Area * a)
  : KDialog(parent->widget(),"",true)
// : KDialogBase(Tabbed,i18n("Area Tag Editor"),Ok|Apply|Cancel,Ok,parent,"")
//	: KDialogBase(parent,"",true,"Area Tag Editor",Ok|Apply|Cancel,Ok,true)
{
  if (!a) {
   slotCancel();
   return;  
  }

  _document=parent;

  setCaption(i18n("Area Tag Editor"));

  area=a;
  TQString shape="Default";
  areaCopy= a->clone();
  oldArea= new Area();
  oldArea->setRect( a->rect() );

  switch (a->type()) {
    case Area::Rectangle : shape=i18n("Rectangle");break;
    case Area::Circle : shape=i18n("Circle");break;
    case Area::Polygon : shape=i18n("Polygon");break;
    case Area::Selection : shape=i18n("Selection");break;
    default : break;
  }


  // To get a margin around everything

  TQVBoxLayout *layout = new TQVBoxLayout(this);

  layout->setMargin(5);

  TQLabel *lbl = new TQLabel("<b>"+shape+"</b>",this);
  lbl->setTextFormat(TQt::RichText);
  layout->addWidget(lbl);

  TQFrame *line = new TQFrame(this);
  line->setFrameStyle(TQFrame::HLine  | TQFrame::Sunken);
  line->setFixedHeight(10);
  layout->addWidget(line);

  TQTabWidget *tab = new TQTabWidget(this);

  layout->addWidget(tab);

  tab->addTab(createGeneralPage(),i18n("&General"));

  if (a->type()==Area::Default)
  {
      shape=i18n("Default");
  }
  else
    tab->addTab(createCoordsPage(),i18n("Coor&dinates"));

  tab->addTab(createJavascriptPage(),i18n("&JavaScript"));

  line = new TQFrame(this);
  line->setFrameStyle(TQFrame::HLine  | TQFrame::Sunken);
  line->setFixedHeight(10);
  layout->addWidget(line);

  layout->addWidget(createButtonBar());

  setMinimumHeight(360);
  setMinimumWidth(327);

  resize(327,360);
}

AreaDialog::~AreaDialog() {
  delete areaCopy;
  delete oldArea;
}

CoordsEdit* AreaDialog::createCoordsEdit(TQWidget *parent, Area *a) {
  if (!a) return 0;
  switch (a->type()) {
    case Area::Rectangle :
        return new RectCoordsEdit(parent,a);
      break;
    case Area::Circle :
        return new CircleCoordsEdit(parent,a);
      break;
    case Area::Polygon :
        return new PolyCoordsEdit(parent,a);
      break;
    case Area::Selection :
        return new SelectionCoordsEdit(parent,a);
      break;
    case Area::Default : return new CoordsEdit(parent,a); break;
    default : return new CoordsEdit(parent,a);break;
  }
}

void AreaDialog::slotChooseHref() {
  KURL url=KFileDialog::getOpenURL(TQString(), "*|" + i18n( "All Files" ), this, i18n("Choose File"));
  if (!url.isEmpty()) {
    hrefEdit->setText(url.url());
  }
}

void AreaDialog::slotOk() {
  if (area)
  {
    area->highlightSelectionPoint(-1);
    if (area->type()==Area::Default)
      area->setFinished(defaultAreaChk->isChecked());
  }
  slotApply();
  accept();

}

void AreaDialog::slotApply() {
  if (area) {
    if (area->type()!=Area::Default)
      coordsEdit->applyChanges();

    area->setAttribute("href",hrefEdit->text());
    area->setAttribute("alt",altEdit->text());
    area->setAttribute("target",targetEdit->text());
    area->setAttribute("title",titleEdit->text());
    area->setAttribute("onclick",onClickEdit->text());
    area->setAttribute("ondblclick",onDblClickEdit->text());
    area->setAttribute("onmousedown",onMouseDownEdit->text());
    area->setAttribute("onmouseup",onMouseUpEdit->text());
    area->setAttribute("onmousemove",onMouseMoveEdit->text());
    area->setAttribute("onmouseover",onMouseOverEdit->text());
    area->setAttribute("onmouseout",onMouseOutEdit->text());

    // redraw old area to get rid of it
    emit areaChanged(oldArea);
    // draw new area
    emit areaChanged(area);
    oldArea->setRect(area->rect());
  }
}

void AreaDialog::slotCancel() {
  if (area) {
    AreaSelection *selection=0L;
    if ( (selection=dynamic_cast<AreaSelection*>(areaCopy)) )
      area->setArea(*selection);
    else
      area->setArea(*areaCopy);
    area->highlightSelectionPoint(-1);
    emit areaChanged(oldArea);
    emit areaChanged(area);
  }
  reject();
}

void AreaDialog::slotUpdateArea() {
    emit areaChanged(oldArea);
    // draw new area
    emit areaChanged(area);
    oldArea->setRect(area->rect());
}

ImageMapChooseDialog::ImageMapChooseDialog(TQWidget* parent,TQPtrList<MapTag> *_maps,TQPtrList<ImageTag> *_images,const KURL & _baseUrl)
  : KDialogBase(parent,"",true,i18n( "Choose Map & Image to Edit" ),Ok,Ok,true)
{
  baseUrl=_baseUrl;
  maps=_maps;
  images=_images;
  currentMap=0L;
  TQWidget *page=new TQWidget(this);
  setMainWidget(page);
  setCaption(baseUrl.fileName());
  TQVBoxLayout *layout = new TQVBoxLayout(page,5,5);

  TQLabel *lbl= new TQLabel(i18n("Select an image and/or a map that you want to edit"),page);
  lbl->setFont(TQFont("Sans Serif",12, TQFont::Bold));
  layout->addWidget(lbl);
  TQFrame *line= new TQFrame(page);
  line->setFrameStyle(TQFrame::HLine  | TQFrame::Sunken);
  line->setFixedHeight(10);
  layout->addWidget(line,0);

  TQGridLayout *gridLayout= new TQGridLayout(layout,2,3,5);
  gridLayout->setRowStretch(0,0);
  gridLayout->setRowStretch(1,100);
  lbl=new TQLabel(i18n("&Maps"),page);
  mapListBox= new TQListBox(page);
  lbl->setBuddy(mapListBox);
  gridLayout->addWidget(lbl,0,0);
  gridLayout->addWidget(mapListBox,1,0);

  line= new TQFrame(page);
  line->setFrameStyle(TQFrame::VLine | TQFrame::Sunken);
  line->setFixedWidth(10);
//	line->setSizePolicy(TQSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Expanding));
  gridLayout->addWidget(line,1,1);

  lbl=new TQLabel(i18n("Image Preview"),page);
  gridLayout->addWidget(lbl,0,2);

  imagePreview= new TQLabel(page);
  imagePreview->setFixedSize(310,210);
  imagePreview->setSizePolicy(TQSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Expanding));
  imagePreview->setFrameStyle(TQLabel::Panel | TQLabel::Sunken);
  imagePreview->setIndent(5);
  imagePreview->setBackgroundColor(TQColor("white"));
//	imagePreview->setLineWidth(2);
//	imagePreview->setScaledContents(true);
//	lbl= new TQLabel(i18n("&Maps"),page);
//	lbl->setBuddy(mapListBox);
  gridLayout->addWidget(imagePreview,1,2);
//	layout->addLayout(gridLayout,1);

  line= new TQFrame(page);
  line->setFrameStyle(TQFrame::HLine  | TQFrame::Sunken);
  line->setFixedHeight(10);
  layout->addWidget(line,0);


  if (maps->isEmpty()) {
    mapListBox->insertItem(i18n("No maps found"));
    mapListBox->setEnabled(false);
  }
  else {
    for (MapTag *tag = maps->first(); tag!=0L; tag=maps->next()) {
      mapListBox->insertItem(tag->name);
    }
    connect (mapListBox, TQT_SIGNAL(highlighted(int)), this, TQT_SLOT(slotMapChanged(int)));
  }

  initImageListTable(page);

  if (! maps->isEmpty()) {
    mapListBox->setCurrentItem(0);
    slotMapChanged(0);
  }

  resize(510,460);
}

void ImageMapChooseDialog::initImageListTable(TQWidget* parent) {


  if (images->isEmpty()) {
    imageListTable= new TQTable(1,1,parent);
    imageListTable->setText(0,0,i18n("No images found"));
    imageListTable->setEnabled(false);
    imageListTable->horizontalHeader()->hide();
    imageListTable->setTopMargin(0);
    imageListTable->setColumnStretchable(0,true);
  } else {
    imageListTable= new TQTable(images->count(),2,parent);
    imageListTable->setColumnStretchable(0,true);
  }

  imageListTable->verticalHeader()->hide();
  imageListTable->setLeftMargin(0);

  TQLabel *lbl= new TQLabel(i18n("&Images"),parent);
  lbl->setBuddy(imageListTable);

  parent->layout()->add(lbl);
  parent->layout()->add(imageListTable);

  if (images->isEmpty())
    return;

  imageListTable->horizontalHeader()->setLabel(0,i18n("Path"));
  imageListTable->horizontalHeader()->setLabel(1,"usemap");

  imageListTable->setSelectionMode(TQTable::SingleRow);
  imageListTable->setFocusStyle(TQTable::FollowStyle);
  imageListTable->clearSelection(true);


  int row=0;
  for (ImageTag *tag = images->first(); tag!=0L; tag=images->next()) {
    TQString src="";
    TQString usemap="";
    if (tag->find("src"))
      src=*tag->find("src");
    if (tag->find("usemap"))
      usemap=*tag->find("usemap");

    imageListTable->setText(row,0,src);
    imageListTable->setText(row,1,usemap);
    row++;
  }
  connect (imageListTable, TQT_SIGNAL(selectionChanged()), this, TQT_SLOT(slotImageChanged()));

  imageListTable->selectRow(0);
  slotImageChanged();


}

ImageMapChooseDialog::~ImageMapChooseDialog() {
}

void ImageMapChooseDialog::slotImageChanged()
{
  int i=imageListTable->currentRow();
  TQImage pix;
  if (images->at(i)->find("src")) {
    TQString str=*images->at(i)->find("src");
    // relative url
    pixUrl=KURL(baseUrl,str);
    pix=TQImage(pixUrl.path());
    double zoom1=1;
    double zoom2=1;
    if (pix.width()>300)
      zoom1=(double) 300/pix.width();
    if (pix.height()>200)
      zoom2=(double) 200/pix.height();


    zoom1= zoom1 < zoom2 ? zoom1 : zoom2;
    pix=pix.smoothScale((int)(pix.width()*zoom1),int(pix.height()*zoom1));
  }
  TQPixmap pix2;
  pix2.convertFromImage(pix);
  imagePreview->setPixmap(pix2);

//	imagePreview->repaint();
}

void ImageMapChooseDialog::selectImageWithUsemap(const TQString & usemap) {
  for (int i=0; i<imageListTable->numRows(); i++) {
    if (imageListTable->text(i,1)==usemap) {
      imageListTable->selectRow(i);
      slotImageChanged();
      return;
    }
  }
}

void ImageMapChooseDialog::slotMapChanged(int i) {
  currentMap=maps->at(i);
  selectImageWithUsemap(currentMap->name);
}

PreferencesDialog::PreferencesDialog(TQWidget *parent, TDEConfig* conf)
  : KDialogBase(parent,"",true,i18n("Preferences"),Ok|Apply|Cancel,Ok,true)
{
  config = conf;
  TQVBox *page=new TQVBox(this);
  page->setSpacing(6);
  setMainWidget(page);

  TQHBox *hbox= new TQHBox(page);

  TQLabel *lbl = new TQLabel(i18n("&Maximum image preview height:")+" ",hbox);
  rowHeightSpinBox = new TQSpinBox(hbox);
  lbl->setBuddy(rowHeightSpinBox);

  config->setGroup("Appearance");
  rowHeightSpinBox->setMaxValue(1000);
  rowHeightSpinBox->setMinValue(15);
  rowHeightSpinBox->setFixedWidth(60);
  rowHeightSpinBox->setValue(config->readNumEntry("maximum-preview-height",50));

  config->setGroup("General");

  hbox= new TQHBox(page);
  lbl = new TQLabel(i18n("&Undo limit:")+" ",hbox);
  undoSpinBox = new TQSpinBox(hbox);
  undoSpinBox->setFixedWidth(60);
  lbl->setBuddy(undoSpinBox);

  undoSpinBox->setMaxValue(100);
  undoSpinBox->setMinValue(1);
  undoSpinBox->setValue(config->readNumEntry("undo-level",20));

  hbox= new TQHBox(page);
  lbl = new TQLabel(i18n("&Redo limit:")+" ",hbox);

  redoSpinBox = new TQSpinBox(hbox);
  redoSpinBox->setFixedWidth(60);
  redoSpinBox->setMaxValue(100);
  redoSpinBox->setMinValue(1);
  redoSpinBox->setValue(config->readNumEntry("redo-level",20));
  lbl->setBuddy(redoSpinBox);

  startWithCheck = new TQCheckBox(i18n("&Start with last used document"),page);
  startWithCheck->setChecked(config->readBoolEntry("start-with-last-used-document",true));

/*
  hbox= new TQHBox(page);
  (void)new TQLabel(i18n("Highlight Areas")+" ",hbox);

  colorizeAreaChk = new TQCheckBox(hbox);
  colorizeAreaChk->setFixedWidth(60);
  colorizeAreaChk->setChecked(kapp->config()->readBoolEntry("highlightareas",true));

  hbox= new TQHBox(page);
  (void)new TQLabel(i18n("Show alternative text")+" ",hbox);

  showAltChk = new TQCheckBox(hbox);
  showAltChk->setFixedWidth(60);
  showAltChk->setChecked(kapp->config()->readBoolEntry("showalt",true));
*/
}

PreferencesDialog::~PreferencesDialog() {
}

void PreferencesDialog::slotDefault( void ) {
  rowHeightSpinBox->setValue(50);
}

void PreferencesDialog::slotOk( void ) {
  slotApply();
  accept();
}

void PreferencesDialog::slotApply( void ) {
  config->setGroup("Appearance");
  config->writeEntry("maximum-preview-height",rowHeightSpinBox->cleanText().toInt());

  config->setGroup("General Options");
  config->writeEntry("undo-level",undoSpinBox->cleanText().toInt());
  config->writeEntry("redo-level",redoSpinBox->cleanText().toInt());
  config->writeEntry("start-with-last-used-document", startWithCheck->isChecked());

  config->sync();
  emit applyClicked();
}

HTMLPreviewDialog::HTMLPreviewDialog(TQWidget* parent, KURL url, const TQString & htmlCode)
  : KDialogBase(parent, "", true, i18n("Preview"), KDialogBase::Ok)
{
  tempFile = new KTempFile(url.directory(false), ".html");
  tempFile->setAutoDelete(true);
  (*tempFile->textStream()) << htmlCode;
  kdDebug() << "HTMLPreviewDialog: TempFile : " << tempFile->name() << endl;
  tempFile->close();

  TQVBox *page = makeVBoxMainWidget();

  htmlPart = new TDEHTMLPart(page,"htmlpart");
//  htmlView = new TDEHTMLView(htmlPart, page);
//  htmlView->setVScrollBarMode(TQScrollView::Auto);
//  htmlView->setHScrollBarMode(TQScrollView::Auto);
//  dialog->resize(dialog->calculateSize(edit->maxLineWidth(),edit->numLines()*));
//	dialog->adjustSize();
  TQLabel* lbl = new TQLabel(page,"urllabel");

  connect( htmlPart, TQT_SIGNAL( onURL(const TQString&)), lbl, TQT_SLOT( setText(const TQString&)));
}

HTMLPreviewDialog::~HTMLPreviewDialog() {
  delete tempFile;
  delete htmlPart;
}

void HTMLPreviewDialog::show() {
  KDialogBase::show();
  htmlPart->openURL(KURL( tempFile->name() ));
//  htmlView->layout();
//  htmlView->repaint();
  resize(800,600);
}

#include "kimedialogs.moc"
