/***************************************************************************
                          imagemapeditor.h  -  description
                             -------------------
    begin                : Wed Apr 4 2001
    copyright            : (C) 2001 by Jan Sch?fer
    email                : janschaefer@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KIMAGEMAPDIALOG_H
#define KIMAGEMAPDIALOG_H

#include <tqptrlist.h>
#include <tqobjectlist.h>
#include <tqdict.h>
#include <tqimage.h>
#include <kurl.h>
#include <tdeparts/part.h>
#include <tdeparts/browserextension.h>
#include <tdeparts/factory.h>

#include <tdeversion.h>

#include "kimearea.h"

/**
  *@author Jan Schaefer
  */


class TQListView;
class TQPushButton;
class DrawZone;
class TQComboBox;
class TQListViewItem;
class TDEToggleAction;




/**
 * Stores an area tag and all its attributes
 */
typedef TQDict<TQString> AreaTag;

/**
 * Stores an image tag and all its attributes
 * the origcode attribute hold the original htmlcode
 * of this tag
 */
typedef TQDict<TQString> ImageTag;

/**
 * Only a small class to give a list of AreaTags a name
 */
class MapTag : public TQPtrList<AreaTag> {
public:
    MapTag();
    TQString name;
    bool modified;
};


class HtmlElement {
public:
    HtmlElement(const TQString & s) {
        htmlCode = s;
    };
    virtual ~HtmlElement() {}
    ;
    TQString htmlCode;
};

class HtmlMapElement : public HtmlElement {
public:
    HtmlMapElement(const TQString & s) : HtmlElement(s) {
        mapTag = 0L;
    };

    virtual ~HtmlMapElement() {};

    MapTag *mapTag;
};

class HtmlImgElement : public HtmlElement {
public:
HtmlImgElement(const TQString & s) : HtmlElement(s) {
        imgTag = 0L;
    };
    virtual ~HtmlImgElement() {}
    ;
    ImageTag *imgTag;
};

/**
 * Stores the hole HTML content in a List.
 */
class HtmlContent : public TQPtrList<HtmlElement> {}
;


class TDESelectAction;
class TDERadioAction;
class TDERecentFilesAction;
class TDEAction;
#if TDE_VERSION < 300
  class TDEAccel;
#endif
///class TQListViewItem;
class KCommandHistory;
class TDEApplication;
class TQTabWidget;
class AreaListView;
class ImagesListView;
class MapsListView;
class KDockWidget;
class KDockMainWindow;

// needed by the statusbar
#define STATUS_CURSOR 1000
#define STATUS_SELECTION 1001

class KImageMapEditor : public KParts::ReadWritePart {
    Q_OBJECT
  
public :
    enum ToolType { Selection, Rectangle, Circle, Polygon, Freehand, AddPoint, RemovePoint };

    KImageMapEditor(TQWidget *parentWidget, const char *,
                    TQObject *parent, const char *name, const TQStringList & args = TQStringList());
    virtual ~KImageMapEditor();

    static TDEAboutData *createAboutData();
    static TDEConfig *config();

    /**
    * Makes sure, that the actions cut, copy, delete and
    * show properties
    * can only be executed if sth. is selected.
    **/
    void updateActionAccess();

    DrawZone* getDrawZone() {
        return drawZone;
    };

    void addAreaAndEdit(Area*);
    void addArea(Area*);
    AreaListIterator areaList() const;
    KImageMapEditor::ToolType currentToolType() const;
    void deleteSelected();
    void deleteArea( Area * area);
    void deleteAllAreas();
    void deselectAll();
    void deselect(Area* s);
    void deselectWithoutUpdate(Area*);
    TQString getHTMLImageMap() const;
    Area* onArea(const TQPoint & p) const;
    TQPixmap makeListViewPix(Area &) ;
    TQString mapName() const;
    void select(Area*);
    void selectWithoutUpdate(Area*);
    void select(TQListViewItem*);
    AreaSelection* selected() const;
    void setPicture(const TQImage & pix);
    int showTagEditor(Area *);
    KCommandHistory *commandHistory() const;

    TDEApplication* app() const;

    // Only refreshes the listView
    void updateSelection() const;

    void readConfig();
    void writeConfig();

    virtual void readProperties(TDEConfig *);
    virtual void saveProperties(TDEConfig *);
    virtual bool closeURL();
    bool queryClose();
    virtual void setReadWrite(bool);
    TQString getHtmlCode();

    /**
     * Reimplemented to disable and enable Save action
     */
    virtual void setModified(bool);

    /**
     * Opens the given file.
     * If it's an HTML file openURL is called
     * If it's an Image, the image is added to the image list
     */
    void openFile(const KURL &);

    /**
     * Opens the last URL the user worked with.
     * Sets also, the last map and the last image
     */
    void openLastURL(TDEConfig*);

    void readConfig(TDEConfig*);
    void writeConfig(TDEConfig*);

    virtual bool openURL(const KURL & url);

protected:
    void init();
    bool openHTMLFile(const KURL &, const TQString & mapName = TQString(), const TQString & imagePath = TQString());
    void saveImageMap(const KURL &);

    /**
     * Returns a language dependend background picture, with
     * the text : Drop an image or html file
     */
    TQImage getBackgroundImage();


    /**
     * Saves information to restore the last working state
     */
    void saveLastURL(TDEConfig*);


private:
    // Stores the hole html file in a List
    // The entries are either a MapTag an ImageTag or a TQString
    HtmlContent _htmlContent;

    // the url of the working image;
    KURL _imageUrl;
    TQString _mapName;
    TQImage _backgroundImage;

    bool backupFileCreated;

    KImageMapEditor::ToolType _currentToolType;
    AreaList *areas;
    AreaSelection *currentSelected;
    AreaSelection *copyArea;
    Area *defaultArea;
    DrawZone* drawZone;
    TQTabWidget* tabWidget;
    AreaListView *areaListView;
    ImagesListView* imagesListView;
    MapsListView* mapsListView;
    HtmlMapElement* currentMapElement;

    //
    // Actions
    //
    TDESelectAction* zoomAction;
    TDERadioAction *arrowAction;
    TDERadioAction *circleAction;
    TDERadioAction *rectangleAction;
    TDERadioAction *polygonAction;
    TDERadioAction *freehandAction;
    TDERadioAction *addPointAction;
    TDERadioAction *removePointAction;

    TDEAction *cutAction;
    TDEAction *deleteAction;
    TDEAction *copyAction;
    TDEAction *pasteAction;
    TDEAction *zoomInAction;
    TDEAction *zoomOutAction;

    TDEAction *mapNewAction;
    TDEAction *mapDeleteAction;
    TDEAction *mapNameAction;
    TDEAction *mapDefaultAreaAction;

    TDEAction *imageAddAction;
    TDEAction *imageRemoveAction;
    TDEAction *imageUsemapAction;

    TDEToggleAction *highlightAreasAction;
    TDEToggleAction *showAltAction;

    TDEAction *areaPropertiesAction;

    TDEAction *moveLeftAction;
    TDEAction *moveRightAction;
    TDEAction *moveUpAction;
    TDEAction *moveDownAction;

    TDEAction *increaseWidthAction;
    TDEAction *decreaseWidthAction;
    TDEAction *increaseHeightAction;
    TDEAction *decreaseHeightAction;

    TDEAction *toFrontAction;
    TDEAction *toBackAction;
    TDEAction *forwardOneAction;
    TDEAction *backOneAction;

    TDEToggleAction* configureShowAreaListAction;
    TDEToggleAction* configureShowMapListAction;
    TDEToggleAction* configureShowImageListAction;


  	TDERecentFilesAction* recentFilesAction;

    #if TDE_VERSION < 300
      TDEAccel *accel;
    #endif

    KDockMainWindow *mainDock;
    KDockWidget* areaDock;
    KDockWidget* mapsDock;
    KDockWidget* imagesDock;

    KCommandHistory *_commandHistory;
    int maxAreaPreviewHeight;

    TQString cursorStatusText;
    TQString selectionStatusText;

    void setupActions();
    void setupStatusBar();
    void updateStatusBar();
    /* refreshes all Areas, only used by preferences dialog
     * updates only the preview pictures*/
    void updateAllAreas();
    void updateUpDownBtn();

    TQDict<TQString> getTagAttributes(TQTextStream & s,TQString &);

    void setMap(HtmlMapElement*);
    void setMap(MapTag*);
    void addMap(const TQString &);

    // Returns the entire html file as a String
    HtmlElement* findHtmlElement(const TQString &);
    HtmlImgElement* findHtmlImgElement(ImageTag*);
    HtmlMapElement* findHtmlMapElement(const TQString &);
    void deleteAllMaps();
    void addImage(const KURL &);
    void setImageActionsEnabled(bool);
    void setMapActionsEnabled(bool);

    void saveAreasToMapTag(MapTag*);
    void showPopupMenu(const TQPoint &, const TQString &);
    void drawToCenter(TQPainter* p, const TQString & str, int y, int width);

public slots:
    void slotChangeStatusCoords(int x,int y);
    void slotUpdateSelectionCoords();
    void slotUpdateSelectionCoords( const TQRect &);
    void slotAreaChanged(Area *);
    void slotShowMainPopupMenu(const TQPoint &);
    void slotShowMapPopupMenu(TQListViewItem *, const TQPoint &);
    void slotShowImagePopupMenu(TQListViewItem *, const TQPoint &);
    void slotConfigChanged();
    void setPicture(const KURL & url);
    void setMap(const TQString &);
    void setMapName(const TQString & s);


protected slots:
    // overriden from KReadWritePart
    virtual bool openFile();

    virtual bool saveFile() {
        saveImageMap( url() );
//        setModified(false);
        return true;
    }

    void fileOpen();
    void fileSaveAs();
    void fileSave();
    void fileClose();

    void slotShowPopupMenu(TQListViewItem*,const TQPoint &);
    void slotShowPreferences();
    void slotHightlightAreas();
    void slotShowAltTag();
    void slotSelectionChanged();

    int showTagEditor(TQListViewItem *item);
    int showTagEditor();

    void slotZoom();
    void slotZoomIn();
    void slotZoomOut();

    void slotCut();
    void slotCopy();
    void slotPaste();
    void slotDelete();

    void slotDrawArrow();
    void slotDrawCircle();
    void slotDrawRectangle();
    void slotDrawPolygon();
    void slotDrawFreehand();
    void slotDrawAddPoint();
    void slotDrawRemovePoint();

    void mapDefaultArea();
    void mapNew();
    void mapDelete();
    void mapEditName();
    void mapShowHTML();
    void mapPreview();

    void slotBackOne();
    void slotForwardOne();
    void slotToBack();
    void slotToFront();

    void slotMoveUp();
    void slotMoveDown();
    void slotMoveLeft();
    void slotMoveRight();

    void slotIncreaseHeight();
    void slotDecreaseHeight();
    void slotIncreaseWidth();
    void slotDecreaseWidth();

    void slotCancelDrawing();

    void configureShowAreaList();
    void configureShowMapList();
    void configureShowImageList();


    //	void slotPreferences();
    void imageAdd();
    void imageRemove();
    void imageUsemap();

    void dockingStateChanged();

};


inline KImageMapEditor::ToolType KImageMapEditor::currentToolType() const {
    return _currentToolType;
}

inline TQString KImageMapEditor::mapName() const {
    return _mapName;
}

inline KCommandHistory* KImageMapEditor::commandHistory() const {
    return _commandHistory;
}


#endif
