/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2002 by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

**************************************************************************** */
#include "kbcharselect.h"

#include <tdeconfig.h>
#include <kcharselect.h>
#include <kdialog.h>
#include <tdelocale.h>

#include <tqlabel.h>
#include <tqspinbox.h>
#include <tqscrollview.h>

KBCharSelect::KBCharSelect(TQWidget* parent,const char* name)
             : TQVBox(parent,name)
{
    setSpacing( KDialog::spacingHint() );
    
    TQHBox* bar = new TQHBox(this);
    bar->setSpacing( KDialog::spacingHint() );
    
    TQLabel *lTable = new TQLabel( i18n( "Table:" ), bar );
    _tableNum = new TQSpinBox( 0, 255, 1, bar );
    lTable->setBuddy( _tableNum );
    bar->setStretchFactor( _tableNum, 1 );
    
    TQScrollView* scroll = new TQScrollView( this );    
    _table = new KCharSelectTable(scroll,"charselector","helvetica",' ',0);
    _table->setNumCols(16);
    _table->setNumRows(16);
    
    scroll->addChild(_table);
    
    connect( _table, TQT_SIGNAL( doubleClicked() ), this, TQT_SLOT( emitChar() ) );
    connect( _tableNum, TQT_SIGNAL( valueChanged(int) ), this, TQT_SLOT( setTab(int) ));
}

void KBCharSelect::emitChar()
{
    emit characterDoubleClicked( _table->chr() );
}

void KBCharSelect::setTab(int value)
{
    _table->setTableNum( value );
}

void KBCharSelect::saveSettings(TDEConfig* config)
{
    TDEConfigGroupSaver saver(config, "KBCharSelector" );
	
    config->writeEntry( "TableNum", _tableNum->value() );
    config->writeEntry( "SelectedChar", TQString(_table->chr()) );
}

void KBCharSelect::restoreSettings(TDEConfig* config)
{
    TDEConfigGroupSaver saver(config, "KBCharSelector" );
    
    _tableNum->setValue( config->readNumEntry("TableNum", 0 ));
    _table->setChar( config->readEntry("SelectedChar"," ").at(0));
}

#include "kbcharselect.moc"
