/***************************************************************************
                  kocrbase.h  - base dialog for OCR
                             -------------------
    begin                : Sun Jun 11 2000
    copyright            : (C) 2000 by Klaas Freitag
    email                : freitag@suse.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *  This file may be distributed and/or modified under the terms of the    *
 *  GNU General Public License version 2 as published by the Free Software *
 *  Foundation and appearing in the file COPYING included in the           *
 *  packaging of this file.                                                *
 *
 *  As a special exception, permission is given to link this program       *
 *  with any version of the KADMOS ocr/icr engine of reRecognition GmbH,   *
 *  Kreuzlingen and distribute the resulting executable without            *
 *  including the source code for KADMOS in the source distribution.       *
 *
 *  As a special exception, permission is given to link this program       *
 *  with any edition of TQt, and distribute the resulting executable,       *
 *  without including the source code for TQt in the source distribution.   *
 *                                                                         *
 ***************************************************************************/

#ifndef KOCRBASE_H
#define KOCRBASE_H

#include <kdialogbase.h>
#include <tdeio/previewjob.h>
#include <tqimage.h>
#include <tqstring.h>

#include <kscanslider.h>
#include <kanimwidget.h>
#include <ksconfig.h>

#include "ksaneocr.h"
/**
  *@author Klaas Freitag
  */


class KookaImage;
class TQHBox;
class TQVBox;
class TQLabel;
class TQSize;
class KSpellConfig;
class TQCheckBox;
class TQGroupBox;

class KOCRBase: public KDialogBase
{
    Q_OBJECT
  
public:
    KOCRBase( TQWidget *, KSpellConfig *spellConfig,
              KDialogBase::DialogType face = KDialogBase::Plain );
    ~KOCRBase();

    virtual EngineError setupGui();

    /**
     * @return the name of the ocr engine
     */
    virtual TQString ocrEngineName() const { return TQString(); }

    /**
     * @return the filename (without path) of the logo of the ocr engine.
     * the logo needs to be installed in $TDEDIR/share/apps/kooka/pics
     */
    virtual TQString ocrEngineLogo() const { return TQString(); }

    /**
     * @return a description string of the ocr engine
     */
    virtual TQString ocrEngineDesc() const { return TQString(); }

    TQVBox* ocrPage() const { return m_ocrPage; }
    TQVBox* imagePage() const { return m_imgPage; }

    KSpellConfig* spellConfig() const
        { return m_spellConfig; }

    bool wantSpellCheck();

public slots:
    virtual void stopAnimation();
    virtual void startAnimation();

    virtual void introduceImage( KookaImage* );

    virtual void startOCR();
    virtual void stopOCR();
    /**
     * enable or disable dialog fields. This slot is called when the ocr process starts
     * with parameter state=false and called again if the gui should accept user input
     * again after ocr finished with parameter true.
     */
    virtual void enableFields(bool state);

protected:
    /**
     * This creates a a tab OCR in the dialog and creates a small intro about the
     * ocr engine used.
     * It calls the virtual subs ocrEngineName, ocrEngineLogo and ocrEngineDesc which
     * must return the approbiate values for the engines.
     * @return a pointer to a VBox in which further elements can be layouted
     */
    virtual void ocrIntro();

    /**
     * This creates a a tab Image Info in the dialog and creates a image description
     * about the current image to ocr.
     */
    virtual void imgIntro();

    /**
     * This sets up the spellchecking configuration
     */
    virtual void spellCheckIntro();


protected slots:
    virtual KAnimWidget* getAnimation(TQWidget*);
    virtual void writeConfig();
    virtual void slSpellConfigChanged();

    /**
     * hit if the user toggles the want-spellcheck checkbox
     */
    virtual void slWantSpellcheck( bool wantIt );

private slots:
    virtual void slPreviewResult( TDEIO::Job* );
    virtual void slGotPreview( const KFileItem*, const TQPixmap& );

private:
    KAnimWidget  *m_animation;
    TQVBox        *m_ocrPage;
    TQVBox        *m_imgPage;
    TQVBox        *m_spellchkPage;
    TQVBox        *m_metaBox;
    TQHBox        *m_imgHBox;
    TQLabel       *m_previewPix;
    KookaImage   *m_currImg;

    KSpellConfig *m_spellConfig;
    bool          m_wantSpellCfg;         /* show the spellcheck options? */
    bool          m_userWantsSpellCheck;  /* user has enabled/disabled spellcheck */
    TQSize         m_previewSize;

    TQCheckBox     *m_cbWantCheck;
    TQGroupBox     *m_gbSpellOpts;
};

#endif
