/* Class Spion
 *
 * Josef Weidendorfer, 10/97
 */

#ifndef _SPY_H_
#define _SPY_H_


#include <tqlayout.h>
#include "Board.h"


class BoardWidget;
class TQLabel;

class Spy: public TQWidget
{
  Q_OBJECT
  

public:
  Spy(Board&);
  ~Spy() {}
	
  enum { BoardCount = 5 };

  void clearActBoards();

  void keyPressEvent(TQKeyEvent *e);

public slots:	
  void update(int,int,Move&,bool);
  void updateBest(int,int,Move&,bool);
  void nextStep();
	
private:
  bool next;
  Board &board;
  TQBoxLayout *top;
  BoardWidget *actBoard[BoardCount], *bestBoard[BoardCount];
  TQLabel *actLabel[BoardCount], *bestLabel[BoardCount];
};



#endif /* _SPION_H_ */
