#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqstring.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>

#include <kdialog.h>
#include <tdelocale.h>

#include "stacklevel.h"

StackLevel::StackLevel(int id, TQWidget *parent, const char *name)
	: TQHBox(parent, name)
{
	setSpacing(KDialog::spacingHint());

	this->id = id;

	m_edit = new TQLineEdit(this);
	TQToolTip::add(m_edit, i18n("Stack level %1").arg(TQString::number(id)));
	connect(m_edit, SIGNAL(returnPressed()), this, SLOT(emitEdit()));

	m_button = new TQPushButton(this);
	TQWhatsThis::add(m_button, i18n("Roll from stack level %1").arg(TQString::number(id)));
	TQToolTip::add(m_button, i18n("Roll\nShifted: Roll down"));
	m_button->setText(TQString::number(id));
	connect(m_button, SIGNAL(clicked()), this, SLOT(emitButton()));
}

void StackLevel::emitButton()
{
	emit buttonPressed(id);
}

void StackLevel::emitEdit()
{
	emit returnPressed(id);
}

void StackLevel::setEnabled(bool enabled)
{
	TQHBox::setEnabled(enabled);
	m_edit->setEnabled(enabled);
	m_button->setEnabled(enabled);
}

#include "stacklevel.moc"
