/***************************************************************************
                          qdialarc.h  -  description
                             -------------------
    begin                : Wed Aug 1 2001
    copyright            : (C) 2001 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TQDIALARC_H
#define TQDIALARC_H

#include <ntqwidget.h>

/**
  *@author Miguel Novas
  */

class TQDialArc : public TQWidget  {
   Q_OBJECT
public: 
	TQDialArc(TQWidget *parent=0, const char *name=0);
	~TQDialArc();

  void setValue            (double value);
  void setValueMin         (double value);
  void setValueMax         (double value);
  void setValueRanges      (double min,double max);
  void setValueLimitRanges (double min,double max);
  void setValueMinLimit    (double value, int percent= 15);
  void setValueMaxLimit    (double value, int percent= 15);
  void setValueMaxLimitPercent(int value);
  void setValueMinLimitPercent(int value);

  void setAngle        (int value);
  void setAngleLen     (int value);
  void setAngles       (int angle,int len);

  void setShowMarks (bool flag);

  void setColorMax(const TQColor &color);
  void setColorMid(const TQColor &color);
  void setColorMin(const TQColor &color);
  void setColorRanges(const TQColor &min,const TQColor &mid, const TQColor &max);

  void setArrowColor(const TQColor &color);

  inline double getValue() { return val; }

protected:

  void resizeEvent( TQResizeEvent *);
  void paintEvent ( TQPaintEvent *);

private:

 double val;
 double valMin;
 double valMax;
 double valMaxLimit,valMinLimit;
 int    valMaxLimitPercent,valMinLimitPercent;
 int angleStart,angleLen;
 //
 int radius;
 int centerx,centery;
 bool fCalcParams;

 TQColor arrowColor;
 TQColor colorMin;
 TQColor colorMid;
 TQColor colorMax;
 bool fShowMarks;

 void calcParams();
 void paramsChanged();
 void drawMarks(TQPainter *p,int l1,int l2);
 void drawArc(TQPainter *p,int l1,int l2,const TQColor &color);
 void drawArrow(TQPainter *p, double value);
};

#endif
