/***************************************************************************
                          qbarmeter.h  -  description
                             -------------------
    begin                : Mon Dec 3 2001
    copyright            : (C) 2001 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TQBARMETER_H
#define TQBARMETER_H

#include <ntqpainter.h>
#include <ntqwidget.h>
#include <ntqcolor.h>

/**
  *@author Miguel Novas
  */

class TQBarMeter: public TQWidget {
Q_OBJECT
public:

   enum Direction { dirLeft, dirRight ,dirUp, dirDown };

   TQBarMeter(TQWidget *parent=0, const char *name=0);
   ~TQBarMeter();

   void setDirection(Direction dir);
   void setValueMax(double newVal);
   void setValue(double newVal);
   void setValueColor(const TQColor &newColor);
   void setValueMaxColor(const TQColor &newColor);
   void setSteps(int newSteps);

   void setValue(int index, double newVal);
   void setValueColor(int index, const TQColor &newColor);
   void setValueCount(int count);
   void useValueMax(bool flag);

protected:

   double val[8];
   TQColor color[8];
   bool   useValMax;
   double valMax;
   TQColor maxColor;
   int count;
   int steps;
   Direction dir;
   void paintEvent( TQPaintEvent *);
};

#endif
