//
// C++ Interface: komposepreferences
//
// Description:
//
//
// Author: Hans Oischinger <hans.oischinger@kde-mail.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KOMPOSEPREFERENCES_H
#define KOMPOSEPREFERENCES_H

#include <kdialogbase.h>

#include <tdelocale.h>

class TQCheckBox;
class TQFrame;
class TQSpinBox;
class KColorButton;
class TQButtonGroup;
class TQSlider;
class TQPushButton;
class TQFont;
class TQRadioButton;
class TQComboBox;

/**
@author Hans Oischinger
*/
class KomposePreferences : public KDialogBase
{
  Q_OBJECT
public:
  KomposePreferences();

  ~KomposePreferences();


protected:
  void fillPages();

protected slots:
  void slotApply();
  void slotOk();
  void updateIconSliderDesc( int );
  void showDesktopTitleFontDialog();
  void showWindowTitleFontDialog();
  void setUseCompositeToggled( bool );

private:
  bool m_hasXinerama;
  TQFrame *page1;
  TQFrame *page2;

  TQButtonGroup *defaultViewBtnGroup;
  TQRadioButton *defaultViewWorld;
  TQRadioButton *defaultViewVirtualDesks;
  TQRadioButton *defaultViewCurrentDesk;

  TQCheckBox *useComposite;

  TQCheckBox *passiveScreenshots;
  TQCheckBox *dynamicVirtDeskLayout;
  TQCheckBox *cacheScaledPixmaps;

  TQCheckBox *imageEffects;
  TQCheckBox *blurBackground;

  TQSpinBox *screenshotGrabDelay;

  TQCheckBox *showIcons;
  TQSlider *iconSize;
  TQLabel *iconSizeDescription;

  TQCheckBox *showWindowTitles;
  TQPushButton *windowTitleFontBtn;
  TQFont *windowTitleFont;

  TQLabel *windowBorderActiveColorLabel;
  TQLabel *windowBorderInactiveColorLabel;
  TQLabel *windowBorderActiveStyleLabel;
  TQLabel *windowBorderInactiveStyleLabel;
  KColorButton *windowBorderActiveColor;
  KColorButton *windowBorderInactiveColor;
  TQComboBox *windowBorderActiveStyle;
  TQComboBox *windowBorderInactiveStyle;
  TQSpinBox *windowBorderActiveWidth;
  TQSpinBox *windowBorderInactiveWidth;

  KColorButton *windowTitleFontColor;
  TQCheckBox *showWindowTitleShadow;
  KColorButton *windowTitleFontShadowColor;
  TQLabel *windowTitleFontColorLabel;

  TQPushButton *desktopTitleFontBtn;
  TQLabel *desktopTitleFontColorLabel;
  TQLabel *desktopTitleFontHighlightColorLabel;
  KColorButton *desktopTitleFontColor;
  KColorButton *desktopTitleFontHighlightColor;
  TQFont *desktopTitleFont;

  TQCheckBox *m_topLeftCorner;
  TQCheckBox *m_bottomLeftCorner;
  TQCheckBox *m_topRightCorner;
  TQCheckBox *m_bottomRightCorner;

  TQCheckBox *m_topEdge;
  TQCheckBox *m_bottomEdge;
  TQCheckBox *m_rightEdge;
  TQCheckBox *m_leftEdge;
  TQSpinBox *autoLockDelay;

  TQCheckBox *showDesktopNum;

  TQSpinBox *m_viewScreen;
  TQCheckBox *m_viewScreenAll;
};

#endif
