//Author:    Max Howell <max.howell@methylblue.com>, (C) 2003-4
//Copyright: See COPYING file that comes with this distribution

#ifndef HISTORYACTION_H
#define HISTORYACTION_H

#include <tdeaction.h>
#include <kurl.h>
#include <tqstringlist.h>

class TDEConfig;


/// defined in mainWindow.cpp
void setActionMenuTextOnly( TDEAction *a, TQString const &suffix );


class HistoryAction : TDEAction
{
    HistoryAction( const TQString &text, const char *icon, const TDEShortcut &cut, TDEActionCollection *ac, const char *name );

    friend class HistoryCollection;

public:
    virtual void setEnabled( bool b = true ) { TDEAction::setEnabled( b ? !m_list.isEmpty() : false ); }

    void clear() { m_list.clear(); TDEAction::setText( m_text ); }

private:
    void setText();

    void push( const TQString &path );
    TQString pop();

    const TQString m_text;
    TQStringList m_list;
};


class HistoryCollection : public TQObject
{
Q_OBJECT
  

public:
    HistoryCollection( TDEActionCollection *ac, TQObject *parent, const char *name );

    void save( TDEConfig *config );
    void restore( TDEConfig *config );

public slots:
    void push( const KURL& );
    void stop() { m_receiver = 0; }

signals:
    void activated( const KURL& );

private slots:
    void pop();

private:
    HistoryAction *m_b, *m_f, *m_receiver;
};

#endif
