/** -*- C++ -*-
	@file adept/sourceseditor.h
	@author Peter Rockai <me@mornfall.net>
*/

#include <apt-front/sources.h>
#include <adept/sourceseditorui.h>
#include <tdelistview.h>

namespace adept {

using namespace aptFront;

class SourcesEditor : public SourcesEditorUi
{
    Q_OBJECT
  
public:
    SourcesEditor( std::string f, TQWidget *p = 0, const char *n = 0 );
public slots:
    void save();
    void reset();
protected slots:
    void contextMenu( TQListViewItem *, const TQPoint & );
    void contextMenuActivated( int );
    void newAdd();
signals:
    void close();
protected:
    aptFront::Sources m_sources;
    std::string m_filename;
};

class EntryItem : public TDEListViewItem {
public:
    Sources::Entry entry() const {
        return m_entry;
    }
    void setEntry( const Sources::Entry &e ) {
        m_entry = e;
    }
    EntryItem( Sources::Entry e, TDEListView *v, EntryItem *prev )
        : TDEListViewItem( v, prev ), m_entry( e ) {
        init();
    }
    EntryItem( Sources::Entry e, TDEListView *v )
        : TDEListViewItem( v ), m_entry( e ) {
        init();
    }
    void init() {
        setRenameEnabled( 0, false );
        setRenameEnabled( 1, true );
        setRenameEnabled( 2, true );
        setRenameEnabled( 3, true );
    }
    TQString text( int c ) const;
    void setText( int c, const TQString &s );
    virtual void paintCell (TQPainter *p, const TQColorGroup &cg,
                            int column, int width, int alignment);
protected:
    Sources::Entry m_entry;
};

}
