#include <fstream>
#include <iostream>

#include <tqpushbutton.h>
#include <tqlineedit.h>
#include <tqpainter.h>

#include <kdebug.h>
#include <tdepopupmenu.h>
#include <tdelocale.h>

#include "sourceseditor.h"
#include <adept/utils.h>

using namespace aptFront;
using namespace adept;

SourcesEditor::SourcesEditor( std::string f, TQWidget *p, const char *n )
    : SourcesEditorUi( p, n ), m_filename( f )
{
    m_list->setSorting( -1 );
    m_list->setAcceptDrops( true );
    connect( m_close, TQT_SIGNAL( clicked() ),
             this, TQT_SIGNAL( close() ) );
    connect( m_apply, TQT_SIGNAL( clicked() ),
             this, TQT_SLOT( save() ) );
    connect( m_reset, TQT_SIGNAL( clicked() ),
             this, TQT_SLOT( reset() ) );

    connect( m_list, TQT_SIGNAL( contextMenuRequested(
                                 TQListViewItem *, const TQPoint &, int) ),
             this, TQT_SLOT( contextMenu( TQListViewItem *, const TQPoint & ) ) );

    connect( m_newAdd, TQT_SIGNAL( clicked() ),
             this, TQT_SLOT( newAdd() ) );

    reset();
}

void SourcesEditor::newAdd()
{
    Sources::Entry e( true, Sources::Entry::Binary );
    std::string s = m_newLine->text();
    std::istringstream i( s );
    i >> e;
    new EntryItem( e, m_list );
    m_newLine->setText( u8( "" ) );
}

void SourcesEditor::contextMenu( TQListViewItem *, const TQPoint &pt ) {
    EntryItem *s = dynamic_cast< EntryItem * >( m_list->selectedItem() );
    if (!s) return;
    TDEPopupMenu *m = new TDEPopupMenu (this);
    m->insertItem( s->entry().enabled() ? i18n( "Disable" ) : i18n( "Enable" ), 0 );
    m->insertItem( i18n( "Clone" ), 1 );
    m->insertItem( i18n( "Remove" ), 2 );
    connect( m, TQT_SIGNAL( activated( int ) ),
             this, TQT_SLOT( contextMenuActivated( int ) ) );
    m->exec( pt );
    delete m;
}

void SourcesEditor::contextMenuActivated( int i ) {
    EntryItem *s = dynamic_cast< EntryItem * >( m_list->selectedItem() );
    Sources::Entry e = s->entry();
    if (i == 0) {
        e.setEnabled( !e.enabled() );
        s->setEntry( e );
    }
    if (i == 2)
        delete s;
    if (i == 1)
        new EntryItem( e, m_list, s );
}

void SourcesEditor::reset() {
    std::ifstream in( m_filename.c_str() );
    m_sources.clear();
    in >> m_sources;
    utils::Range< Sources::Entry > r = m_sources.entries();
    EntryItem *last = 0;
    m_list->clear();
    while( r != r.end() ) {
        last = last ? new EntryItem( *r, m_list, last ) :
               new EntryItem( *r, m_list );
        ++ r;
    }
}

void SourcesEditor::save() {
    m_sources.clear();
    EntryItem *i = dynamic_cast< EntryItem * >( m_list->firstChild() );
    while (i) {
        m_sources.add( i->entry() );
        i = dynamic_cast< EntryItem * >( i->nextSibling() );
    }
    std::ofstream out( m_filename.c_str() );
    out << m_sources;
    std::cerr << "--" << m_sources << "--" << std::endl;
    out.close();
    reset(); // re-parse
}

/* void SourcesEditor::toggleSelectionEnabled()
{
    EntryItem *s = dynamic_cast< EntryItem * >( m_list->selectedItem() );
    if (s) {
        Sources::Entry e = s->entry();
        e.setEnabled( !e.enabled() );
        s->setEntry( e );
        updateActions();
    }
    } */

TQString EntryItem::text( int c ) const {
    if (entry().type() == Sources::Entry::Comment) {
        if (c == 0)
            if (entry().comment() == "")
                return u8( "" );
            else
                return entry().typeString();
        if (c == 1)
            return entry().comment();
        return u8( "" );
    }

    if (c == 0) return entry().typeString();
    if (c == 1) return entry().url();
    if (c == 2) return entry().distribution();
    if (c == 3) return entry().components();
    return u8( "" );
}

void EntryItem::setText( int c, const TQString &_s )
{
    kdDebug() << "setText on column " << c << endl;
    Sources::Entry e = entry();
    std::string s;
    s = _s.local8Bit();
    if (c == 0) e.setTypeString( s );
    if (c == 1)
        if (entry().type() == Sources::Entry::Comment)
            e.setComment( s );
        else
            e.setUrl( s );
    if (c == 2) e.setDistribution( s );
    if (c == 3) e.setComponents( s );
    setEntry( e );
    TDEListViewItem::setText( c, _s ); // stop qlistview from looping infinitely
}

void EntryItem::paintCell (TQPainter *p, const TQColorGroup &cg,
                            int column, int width, int alignment )
{
    TQColorGroup _cg( cg );
    TQColor c = _cg.text();
    TQPixmap pm( width, height() );
    TQPainter _p( &pm );
    if (!entry().enabled())
        c = TQt::gray;
    _cg.setColor( TQColorGroup::Text, c );
    TDEListViewItem::paintCell( &_p, _cg, column, width, AlignTop );
    p->drawPixmap( 0, 0, pm );
}

