// KDE includes
 
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <kuniqueapplication.h>

#include "app.h"

static TDECmdLineOptions options[] =
{
    { "+command", I18N_NOOP("Command"), 0 },
    TDECmdLineLastOption
};

int main(int argc, char *argv[])
{
    TDELocale::setMainCatalogue("adept");

    TQString description = i18n("Adept Batch");
    
    TDEAboutData aboutData( "adept_batch", 
                          I18N_NOOP("Adept Batch"),
                          "2.1 Cruiser",
                          description.latin1(),
                          TDEAboutData::License_BSD,
                          I18N_NOOP("(c) 2006 Peter Rockai"),
                          0,
                          "http://web.mornfall.net/adept.html");

    aboutData.addAuthor ( "Peter Rockai",
                          I18N_NOOP("developer"),
                          "me at mornfall dot net",
                          "http://web.mornfall.net");

    TDECmdLineArgs::init( argc, argv, &aboutData );
    TDECmdLineArgs::addCmdLineOptions( options ); 

    TDEApplication app;
    TDECmdLineArgs* args = TDECmdLineArgs::parsedArgs();
    TDEGlobal::locale()->insertCatalogue(TQString::fromUtf8("libept"));

    App *ta = new App( args );

    app.setMainWidget( ta );
    ta->show();

    return app.exec();
}
