/* -*- C++ -*- adept/packageinfo.h
	written by Peter Rockai <me@mornfall.net> */

#include <cstddef>
#include <apt-front/cache/entity/package.h>
#include <apt-front/cache/cache.h>
#include <adept/packageinfoui.h>

#ifndef EPT_PACKAGEINFO_H
#define EPT_PACKAGEINFO_H

namespace adept {

using namespace aptFront;

class PackageInfo : public PackageInfoUi, public cache::Observer
{
    Q_OBJECT
  
public:
    PackageInfo( TQWidget *p, const char *n = 0 );
public slots:
    void setVersion( cache::entity::Version v, bool = true );
    void setPackage( cache::entity::Package v );
    void adjustFontSize( int );
public:
    void notifyPostChange( cache::component::Base * );
    void notifyPostRebuild( cache::component::Base * );
    void hideStatus();
protected:
    cache::entity::StableVersion m_version;
    bool m_specificVersion;
};

inline TQString labelFormat( const TQString &what,
                       const TQString &txt, bool nobr = true )
{
    TQString ret = "<b><nobr>" + what + "</nobr></b>&nbsp;" + (nobr ? "<nobr>" : "")
                  + txt + (nobr ? "</nobr>" : "");
    return ret;
}

TQColor actionColor( cache::entity::Package p );
TQColor statusColor( cache::entity::Package p );

TQString formatLongDescription( TQString in );
TQString colorify( TQColor c, TQString s );

}

#endif
