/* -*- C++ -*- */
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqhttp.h>
#include <tqbuffer.h>

#include <kdebug.h>

#include <apt-front/cache/entity/entity.h>
#include <apt-front/cache/entity/package.h>

#include <adept/lister.h>

#include "changelog.h"

using namespace adept;

#ifdef KUBUNTU
ItemChangelog::ItemChangelog() {
  connect(this, TQT_SIGNAL( changelogNeeded() ),
          this, TQT_SLOT( requestChangelog() ));
  m_http = 0;
  m_content_catcher = 0;
}

ItemChangelog::~ItemChangelog() {
  if (m_http != 0) {
    delete m_http;
  }
  if (m_content_catcher != 0) {
    delete m_content_catcher;
  }
}

/*
 * So this method is *very* specific to the ubuntu package
 * changelog repository.  If you want to modify this to meet the needs
 * of another distro, you may want to implement your own method here.
 */
TQString ItemChangelog::changelogUrl() {
  // The list of known sections...
  TQStringList knownSections(TQString("main"));
  knownSections += TQString("multiverse");
  knownSections += TQString("restricted");
  knownSections += TQString("universe");

  // The parts of the package that form the URL...
  TQStringList pkgParts( TQString(BASE_CHANGELOG_URL) );
  TQStringList sectionParts;
  TQString section;
  TQString urlBase;
  TQString pkgName;
  bool found = false;

  try {
    if (&m_pkg == 0x0) {
      throw 0;
    }
    std::string theSection(m_pkg.section(std::string("/")));
    if (!theSection.length()) {
      throw 0;
    }
    //// Get the section
    section = TQString( theSection );
    /* now convert the section into something
       usable for the changelog URL. */
    sectionParts = TQStringList::split(TQString("/"), section);

    /* If we have more than one piece, that means we've got a
       non-main repo.  Let's make sure it's one we can use. */
    if (sectionParts.size() > 1) {
      // Walk through known sections
      for (TQStringList::Iterator it = knownSections.begin();
           it != knownSections.end(); ++it) {
        // If we found it, let's say we found it.
        if (sectionParts[0] == *it) {
          pkgParts += sectionParts[0];
          found = true;
          break;
        }
      }
      if (!found) {
        return TQString(); // didn't find the repo!
      }
    } else {
      pkgParts += TQString("main");
    }

    //// Get the package name and prefix
    pkgName += TQString( m_pkg.source() );
    pkgParts += TQString(pkgName[0]);
    pkgParts += pkgName;

    //// Get the version string.
    TQString version = TQString( m_pkg.candidateVersion().versionString() );
    int epoch = version.find(':');
    if (epoch > -1) {
      version = version.mid(epoch + 1);
    }
    pkgName += "_" + version;
    pkgParts += pkgName;
    pkgParts += TQString("changelog");

    return pkgParts.join(TQString("/"));
  } catch (...) {
    kdDebug() << "GOT ME AN EXCEPTION!!!! THIS IS NOT GOOD!!!!";
  }

  return TQString();
}

void ItemChangelog::requestChangelog() {
//   emit changelogReady(changelogUrl());

//   return;

  /* Removing temporarilly */
  m_http = new TQHttp(TQString(BASE_CHANGELOG_HOST),
                     BASE_CHANGELOG_PORT,
                     this, "changelog_loader");
  connect(dynamic_cast<TQObject*>(m_http), TQT_SIGNAL( requestFinished(int,bool) ),
          dynamic_cast<TQObject*>(this), TQT_SLOT( contentReady(int,bool) ));
  m_content_catcher = new TQBuffer();
  TQString theUrl( changelogUrl() );

  if ( theUrl == TQString() ) {
    emit changelogReady(TQString("No change log found."));
  } else {
    m_http->get( changelogUrl(), dynamic_cast<TQIODevice*>(m_content_catcher) );
  }
}

void ItemChangelog::contentReady( int id, bool error ) {
  TQString msg("Unable to fetch the Developer Changelog.");

  if (!error) {
    msg = TQString( m_content_catcher->buffer() );
  } else {
    msg += ": " + m_http->errorString();
  }

  emit changelogReady( msg );
}

#endif /*KUBUNTU*/
