/** -*- C++ -*-
    @file adept/application.h
    @author Peter Rockai <me@mornfall.net>
*/

#include <vector>

#include <tqobject.h>
#include <tqprocess.h>
#include <kprogress.h>

#include <apt-front/cache/cache.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/cache/component/history.h>

#ifndef EPT_APPLICATION_H
#define EPT_APPLICATION_H

#define KUBUNTU

class KStatusBar;

namespace adept {
using namespace aptFront;
using cache::Cache;

class Lister;

#ifdef KUBUNTU
class DpkgFixer : public TQObject {
  Q_OBJECT
  
public:
  DpkgFixer(struct Application* app);
  ~DpkgFixer();

  bool done() { return m_done; };
public slots:
  void fixDpkgLock();


protected slots:
  void retryOpen();
  void outputUpdated();
  void handleStdout();
  void handleStderr();

protected:
  TQProcess* m_fixer;
  Application* m_parent;
  TQString m_output;
  KProgressDialog* m_waiter;
  bool m_done;
};
#endif // KUBUNTU

struct Application : cache::Observer {
    Application();
  ~Application();
    void setAcceptReadOnly( bool ro ) { m_acceptReadOnly = ro; }
    bool writeable() { return cache::Global::get().writeable(); }
    Cache &cache() { return cache::Global::get(); }
    void openCache( unsigned flags = Cache::OpenDefault | Cache::OpenDebtags );
    void initialize();
  void cacheOpenedNowFinishInit();
    void initKDEDebconf();
    void initHistory();
    void setMainWidget( TQWidget *w ) { m_main = w; }
    void setStatusBar( KStatusBar *s );
    void updateStatusbar();
  virtual void initFinished() { return; };
    virtual void checkpoint();
    virtual void undo();
    virtual void redo();

  int test_this_shit;

    virtual void notifyPostChange( cache::component::Base * );

    TQString changeString();
    TQString statusString();
    TQString sizesString();
  TQWidget* mainWindow() { return m_main; };
  unsigned openFlags() { return m_flags; };

protected:
    virtual void setHistoryEnabled( bool ) {}
    typedef cache::component::History< cache::component::State > History;
    virtual History *history() { return m_history; }
    bool m_acceptReadOnly;
  unsigned m_flags;
    TQWidget *m_main;
    KStatusBar *m_statusBar;
    History *m_history;

#ifdef KUBUNTU
  DpkgFixer* m_dpkgfixer;
#endif // KUBUNTU
};

}

#endif
