/***************************************************************************
 *
 * knetworkmanager-wireless_network.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// NM includes
#include <NetworkManager.h>

// KNM includes
#include "knetworkmanager.h"
#include "knetworkmanager-connection.h"
#include "knetworkmanager-accesspoint.h"
#include "knetworkmanager-wireless_network.h"

// KDE includes
#include <kdebug.h>

// TQt includes
#include <tqhostaddress.h>
#include <tqvaluelist.h>

using namespace ConnectionSettings;

class WirelessNetworkPrivate
{
	public:
	WirelessNetworkPrivate()
	  : active(false)
	{
	}

	~WirelessNetworkPrivate()
	{
	}

	bool       active;

	TQ_UINT32   match;
	TQValueList<const AccessPoint*> aps;
};

WirelessNetwork::WirelessNetwork(const WirelessNetwork& other)
{
	d = new WirelessNetworkPrivate(*other.d);
}

WirelessNetwork::WirelessNetwork(TQ_UINT32 match)
{
	d = new WirelessNetworkPrivate();

	// which attributes have to match
	d->match = match;
}

WirelessNetwork::~WirelessNetwork()
{
	delete d;
}

WirelessNetwork& WirelessNetwork::operator= (const WirelessNetwork& other)
{
	if (d)
		delete d;
	d = new WirelessNetworkPrivate(*other.d);
	return *this;
}

bool WirelessNetwork::contains (const AccessPoint * const ap)
{
	if ( (d->match & MATCH_SSID) && getSsid() != ap->getSsidByteArray())
		return false;

	// AP matches
	return true;
}

bool WirelessNetwork::addAP(const AccessPoint * const ap)
{
	if ( this->contains( ap ) || d->aps.isEmpty())
	{
		d->aps.append(ap);
		return true;
	}
	return false;
}

const TQByteArray WirelessNetwork::getSsid() const
{
	if ( !d->aps.isEmpty() ) {
		return (*(d->aps.begin()))->getSsidByteArray();
	} else {
		return TQByteArray();
	}
}

TQString WirelessNetwork::getDisplaySsid() const
{
	if (!d->aps.isEmpty()) {
		return (*(d->aps.begin()))->getDisplaySsid();
	} else {
		return TQString();
	}
}

TQ_UINT32 WirelessNetwork::getFlags() const
{
	TQ_UINT32 flags = NM_802_11_AP_FLAGS_NONE;
	for (TQValueList<const AccessPoint*>::Iterator it = d->aps.begin(); it != d->aps.end(); ++it)
	{
		flags |= (*it)->getFlags();
	}
	return flags;
}

TQ_UINT32 WirelessNetwork::getWpaFlags() const
{
	TQ_UINT32 flags = NM_802_11_AP_SEC_NONE;
	for (TQValueList<const AccessPoint*>::Iterator it = d->aps.begin(); it != d->aps.end(); ++it)
	{
		flags |= (*it)->getWpaFlags();
	}
	return flags;
}

TQ_UINT32 WirelessNetwork::getRsnFlags() const
{
	TQ_UINT32 flags = NM_802_11_AP_SEC_NONE;
	for (TQValueList<const AccessPoint*>::Iterator it = d->aps.begin(); it != d->aps.end(); ++it)
	{
		flags |= (*it)->getRsnFlags();
	}
	return flags;
}

bool WirelessNetwork::isEncrypted() const
{
	return (getFlags() && NM_802_11_AP_FLAGS_PRIVACY);
}

TQ_UINT8 WirelessNetwork::getStrength() const
{
	TQ_UINT8 strength = 0;
	for (TQValueList<const AccessPoint*>::Iterator it = d->aps.begin(); it != d->aps.end(); ++it)
	{
		if ((*it)->getStrength() > strength)
			strength = (*it)->getStrength();
	}
	return strength;
}

void WirelessNetwork::setActive(bool a)
{
	d->active=a;
}

bool WirelessNetwork::getActive() const
{
	return d->active;
}

