/***************************************************************************
 *
 * knetworkmanager-ppp_connection.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2008 Novell, Inc.
 *
 * Author: Will Stephenson <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_PPP_CONNECTION_H
#define KNETWORKMANAGER_PPP_CONNECTION_H

#include "knetworkmanager-generic_connection.h"
#include "knetworkmanager-connection_setting_ipv4.h"
#include "knetworkmanager-connection_setting_ppp.h"

namespace ConnectionSettings
{
	class Info;
	class IPv4;
	class PPP;

	class PPPConnection : public GenericConnection
	{
		Q_OBJECT
  
		public:
			PPPConnection(const TQString& infoName);
			~PPPConnection();
			PPP* getPPPSetting() const;
			IPv4* getIPv4Setting() const;
	};
} // namespace ConnectionSettings

#endif

