/***************************************************************************
 *
 * knetworkmanager-device.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include "knetworkmanager.h"
#include "knetworkmanager-hal_device_proxy.h"

#include <kdebug.h>
#include <tqhostaddress.h>

class HalDeviceProxyPrivate
{
public:
	HalDeviceProxyPrivate() {}
	~HalDeviceProxyPrivate() {}

	void getHalProperty (const TQCString& udi, const TQCString& property, TQCString& result);

	TQString      udi;
};

HalDeviceProxy::HalDeviceProxy (const TQString & udi)
{
	d = new HalDeviceProxyPrivate;
	d->udi = udi;
}

HalDeviceProxy::~HalDeviceProxy ()
{
	delete d;
}

bustype
HalDeviceProxy::getBustype () const
{
	TQCString device_udi = d->udi.utf8();
	TQCString parent_udi = "";
	TQCString subsystem  = "";

	d->getHalProperty (device_udi, "info.parent", parent_udi);
	d->getHalProperty (parent_udi, "linux.subsystem", subsystem);
	
	if (TQString::compare (subsystem, "pci") == 0)
		return BUS_PCI;
	else if (TQString::compare (subsystem, "usb") == 0)
		return BUS_USB;
	else if (TQString::compare (subsystem, "pcmcia") == 0)
		return BUS_PCMCIA;
	else
		return BUS_UNKNOWN;
}

TQString
HalDeviceProxy::getProduct () const
{
	return "";
}

TQString
HalDeviceProxy::getVendor () const
{
	return "";
}

void
HalDeviceProxyPrivate::getHalProperty (const TQCString& udi, const TQCString& property, TQCString& result)
{
//FIXME: convert to qt3-dbus-api
/*
	DBusConnection* con      = _ctx->getDBus ()->getConnection ();
	LibHalContext*  hal_ctx  = NULL;
	char*           prop_val = NULL;

	if (!con || !property) {
		goto out;
	}

	if (!dbus_bus_name_has_owner (con, "org.freedesktop.Hal", NULL)) {
		kdDebug() << "Error: HAL seems not to be running." << endl;
		goto out;
	}
	
	hal_ctx = libhal_ctx_new ();

	if (!libhal_ctx_set_dbus_connection (hal_ctx, con)) {
		goto out;
	}

	if (!libhal_ctx_init (hal_ctx, NULL)) {
		goto out;
	}

	prop_val = libhal_device_get_property_string (hal_ctx, udi, property, NULL);
	result = prop_val;
	libhal_free_string (prop_val);
out:
	if (hal_ctx) {
		libhal_ctx_shutdown (hal_ctx, NULL);
		libhal_ctx_free (hal_ctx);
	}
*/
	return;
}

#include "knetworkmanager-hal_device_proxy.moc"
