/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_INFO_H
#define KNETWORKMANAGER_CONNECTION_SETTING_INFO_H

#include <stdint.h>
#include <tqhostaddress.h>
#include <tqmap.h>
#include <tqvariant.h>
#include <tqobject.h>
#include <tqdatetime.h>

#include <tqdbusdata.h>
#include "knetworkmanager-connection_setting.h"

/* NM headers */
#include <nm-setting-connection.h>

namespace ConnectionSettings
{

// info setting
class Info : public ConnectionSetting
{
	public:
		Info(Connection* conn, TQString devtype = TQString(), const TQString& name = TQString(), bool autoconnect = false);

		SettingsMap toMap() const;
		void        fromMap(const SettingsMap&);

		TQString     getDevType() const;
		void        setDevType(const TQString&);

		TQString     getName() const;
		void        setName(const TQString&);

		bool        getAutoconnect() const;
		void        setAutoconnect(bool);

		TQDateTime   getTimestamp() const;
		void        setTimestamp(const TQDateTime&);

		TQString     getUUID() const;
		void        setUUID(const TQString&);

		bool        isValid() const;

	private:
		TQString    _name;
		TQString    _devtype;
		bool       _autoconnect;
		TQDateTime  _timestamp;
		TQString    _uuid;
};

}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_INFO_H */
