/***************************************************************************
 *
 * knetworkmanager-connection_setting_gsm.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_GSM_H
#define KNETWORKMANAGER_CONNECTION_SETTING_GSM_H

#include <stdint.h>
#include <tqhostaddress.h>
#include <tqmap.h>
#include <tqvariant.h>
#include <tqobject.h>

#include <tqdbusdata.h>

#include "knetworkmanager-connection_setting.h"

/* NM headers */
#include <nm-setting-gsm.h>

namespace ConnectionSettings
{

class Connection;

// serial setting
class GSM : public ConnectionSetting
{
	public:
		GSM(Connection* conn);

		SettingsMap toMap() const;
		SettingsMap toSecretsMap(bool with_settings = true) const;
		void        fromMap(const SettingsMap&);
		bool        fromSecretsMap(const SettingsMap&);

		bool     isValid() const;
		bool     useSetting();

		void     setNumber(const TQString&);
		TQString  getNumber() const;

		void     setUsername(const TQString&);
		TQString  getUsername() const;

		void     setPassword(const TQString&);
		TQString  getPassword() const;

		void     setAPN(const TQString&);
		TQString  getAPN() const;

		void     setNetworkID(const TQString&);
		TQString  getNetworkID() const;

		void     setNetworkType(int);
		int      getNetworkType() const;

		void     setBand(int);
		int      getBand() const;

		void     setPin(const TQString&);
		TQString  getPin() const;

		void     setPuk(const TQString&);
		TQString  getPuk() const;

	private:
		TQString _number;
		TQString _username;
		TQString _password;
		TQString _apn;
		TQString _network_id;
		int     _network_type;
		int     _band;
		TQString _pin;
		TQString _puk;
};
}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_CDMA_H */
