/***************************************************************************
 *
 * knetworkmanager-connection_setting_gsm.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/* qt headers */
#include <tqhostaddress.h>
#include <tqvariant.h>

/* kde headers */
#include <kdebug.h>
#include <tdelocale.h>

/* TQT_DBus headers*/
#include <tqdbusdata.h>
#include <tqdbusdatamap.h>

/* knetworkmanager headers */
#include "knetworkmanager.h"
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_setting_gsm.h"

/* network-manager headers */
#include <NetworkManager.h>

#if !defined(NM_CHECK_VERSION)
#define NM_CHECK_VERSION(x,y,z) 0
#endif

using namespace ConnectionSettings;

/*
	class GSM
*/
GSM::GSM(Connection* conn)
	: ConnectionSetting(conn, NM_SETTING_GSM_SETTING_NAME), _number("*99#"), _network_type(-1), _band(-1)
{
}

void GSM::setNumber(const TQString& number)
{
	_number = number;
}

TQString GSM::getNumber() const
{
	return _number;
}

void GSM::setUsername(const TQString& username)
{
	_username = username;
}

TQString GSM::getUsername() const
{
	return _username;
}

void GSM::setPassword(const TQString& password)
{
	_password = password;
}

TQString GSM::getPassword() const
{
	return _password;
}

void GSM::setPin(const TQString& pin)
{
	_pin = pin;
}

TQString GSM::getPin() const
{
	return _pin;
}

void GSM::setPuk(const TQString& puk)
{
	_puk = puk;
}

TQString GSM::getPuk() const
{
	return _puk;
}

void GSM::setAPN(const TQString& apn)
{
	_apn = apn;
}

TQString GSM::getAPN() const
{
	return _apn;
}

void GSM::setNetworkID(const TQString& id)
{
	_network_id = id;
}

TQString GSM::getNetworkID() const
{
	return _network_id;
}

void GSM::setNetworkType(int type)
{
	_network_type = type;
}

int GSM::getNetworkType() const
{
	return _network_type;
}

void GSM::setBand(int band)
{
	_band = band;
}

int GSM::getBand() const
{
	return _band;
}

bool
GSM::isValid() const
{
	return true;
}

SettingsMap
GSM::toMap() const
{
	SettingsMap map;

	if (!_number.isEmpty()) {
		map.insert(NM_SETTING_GSM_NUMBER, TQT_DBusData::fromString(_number));
	}
	if (!_username.isEmpty()) {
		map.insert(NM_SETTING_GSM_USERNAME, TQT_DBusData::fromString(_username));
	}
	if (!_apn.isEmpty()) {
		map.insert(NM_SETTING_GSM_APN, TQT_DBusData::fromString(_apn));
	}
	if (!_network_id.isEmpty()) {
		map.insert(NM_SETTING_GSM_NETWORK_ID, TQT_DBusData::fromString(_network_id));
	}
	map.insert(NM_SETTING_GSM_NETWORK_TYPE, TQT_DBusData::fromInt32(_network_type));
#if NM_CHECK_VERSION(0,8,992)
#else
	map.insert(NM_SETTING_GSM_BAND, TQT_DBusData::fromInt32(_band));
#endif

	return map;
}

SettingsMap
GSM::toSecretsMap(bool with_settings) const
{
	SettingsMap map;

	// first serialize the settings if needed
	if (with_settings)
		map = toMap();

	if (!_password.isEmpty()) {
		map.insert(NM_SETTING_GSM_PASSWORD, TQT_DBusData::fromString(_password));
	}
	if (!_pin.isEmpty()) {
		map.insert(NM_SETTING_GSM_PIN, TQT_DBusData::fromString(_pin));
	}
#if NM_CHECK_VERSION(0,8,992)
#else
	if (!_puk.isEmpty()) {
		map.insert(NM_SETTING_GSM_PUK, TQT_DBusData::fromString(_puk));
	}
#endif

	return map;
}

bool
GSM::fromSecretsMap(const SettingsMap& map)
{
	for (SettingsMap::ConstIterator it = map.begin(); it != map.end(); ++it)
	{
		// TODO: add all secrets
		if (it.key() == NM_SETTING_GSM_PASSWORD)
			setPassword(it.data().toString());
		else if (it.key() == NM_SETTING_GSM_PIN)
			setPin(it.data().toString());
#if NM_CHECK_VERSION(0,8,992)
#else
		else if (it.key() == NM_SETTING_GSM_PUK)
			setPuk(it.data().toString());
#endif
		else
			kdWarning() << k_funcinfo << " Unknown secret: " << it.key() << endl;
	}
	return true;
}

void
GSM::fromMap(const SettingsMap& map)
{
	// TODO: add all attributes
	for (SettingsMap::ConstIterator it = map.begin(); it != map.end(); ++it)
	{
		if (it.key() == NM_SETTING_GSM_NUMBER)
			setNumber(it.data().toString());
		else if (it.key() == NM_SETTING_GSM_USERNAME)
			setUsername(it.data().toString());
		else if (it.key() == NM_SETTING_GSM_APN)
			setAPN(it.data().toString());
		else if (it.key() == NM_SETTING_GSM_NETWORK_ID)
			setNetworkID(it.data().toString());
		else if (it.key() == NM_SETTING_GSM_NETWORK_TYPE)
			setNetworkType(it.data().toUInt32());
#if NM_CHECK_VERSION(0,8,992)
#else
		else if (it.key() == NM_SETTING_GSM_BAND)
			setBand(it.data().toUInt32());
#endif
		else
			kdWarning() << k_funcinfo << " Unknown setting: " << it.key() << endl;
	}
}
