/***************************************************************************
 *
 * knetworkmanager-connection_setting_serial.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/* qt headers */
#include <tqhostaddress.h>
#include <tqvariant.h>

/* kde headers */
#include <kdebug.h>
#include <tdelocale.h>

/* TQT_DBus headers*/
#include <tqdbusdata.h>
#include <tqdbusdatamap.h>

/* knetworkmanager headers */
#include "knetworkmanager.h"
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_setting_cdma.h"

using namespace ConnectionSettings;

/*
	class CDMA
*/
CDMA::CDMA(Connection* conn)
	: ConnectionSetting(conn, NM_SETTING_CDMA_SETTING_NAME), _number("#777")
{
}

void CDMA::setNumber(const TQString& number)
{
	_number = number;
}

TQString CDMA::getNumber() const
{
	return _number;
}

void CDMA::setUsername(const TQString& username)
{
	_username = username;
}

TQString CDMA::getUsername() const
{
	return _username;
}

void CDMA::setPassword(const TQString& password)
{
	_password = password;
}

TQString CDMA::getPassword() const
{
	return _password;
}

bool
CDMA::isValid() const
{
	return true;
}

SettingsMap
CDMA::toMap() const
{
	SettingsMap map;

	map.insert(NM_SETTING_CDMA_NUMBER, TQT_DBusData::fromString(_number));
	map.insert(NM_SETTING_CDMA_USERNAME, TQT_DBusData::fromString(_username));
	
	return map;
}

SettingsMap
CDMA::toSecretsMap(bool with_settings) const
{
	SettingsMap map;

	// first serialize the settings if needed
	if (with_settings)
		map = toMap();

	map.insert(NM_SETTING_CDMA_PASSWORD, TQT_DBusData::fromString(_password));

	return map;
}

bool
CDMA::fromSecretsMap(const SettingsMap& map)
{
	for (SettingsMap::ConstIterator it = map.begin(); it != map.end(); ++it)
	{
		if (it.key() == NM_SETTING_CDMA_PASSWORD)
			setPassword(it.data().toString());
		else
			kdWarning() << k_funcinfo << " Unknown setting: " << it.key() << endl;
	}
	return true;
}

void
CDMA::fromMap(const SettingsMap& map)
{
	for (SettingsMap::ConstIterator it = map.begin(); it != map.end(); ++it)
	{
		if (it.key() == NM_SETTING_CDMA_NUMBER)
			setNumber(it.data().toString());
		else if (it.key() == NM_SETTING_CDMA_USERNAME)
			setUsername(it.data().toString());
		else
			kdWarning() << k_funcinfo << " Unknown setting: " << it.key() << endl;
	}
}
