/***************************************************************************
 *
 * knetworkmanager-cdma_connection.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2008 Novell, Inc.
 *
 * Author: Will Stephenson <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include "knetworkmanager-cdma_connection.h"

#include <nm-setting-cdma.h>
#include "knetworkmanager-connection_setting_serial.h"

ConnectionSettings::CDMAConnection::CDMAConnection()
    : PPPConnection(NM_SETTING_CDMA_SETTING_NAME)
{
	appendSetting(new CDMA(this));
	appendSetting(new Serial(this));
}

ConnectionSettings::CDMAConnection::~CDMAConnection()
{

}

ConnectionSettings::CDMA* ConnectionSettings::CDMAConnection::getCDMASetting() const
{
	return dynamic_cast<CDMA*>(getSetting(NM_SETTING_CDMA_SETTING_NAME));
}

ConnectionSettings::Serial* ConnectionSettings::CDMAConnection::getSerialSetting() const
{
	return dynamic_cast<Serial*>(getSetting(NM_SETTING_SERIAL_SETTING_NAME));
}

ConnectionSettings::Connection* ConnectionSettings::CDMAConnection::duplicate()
{
	CDMAConnection* conn = new CDMAConnection();
	conn->updateSettings(this);
	return conn;
}

#include "knetworkmanager-cdma_connection.moc"
