/***************************************************************************
    copyright            : (C) 2004-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef RISIMPORTER_H
#define RISIMPORTER_H

#include "importer.h"
#include "../datavectors.h"

#include <tqstring.h>
#include <tqmap.h>

template<class type>
class TQDict;

namespace Tellico {
  namespace Data {
    class Field;
  }
  namespace Import {

/**
 * @author Robby Stephenson
 */
class RISImporter : public Importer {
Q_OBJECT
  

public:
  /**
   */
  RISImporter(const KURL::List& urls);

  /**
   * @return A pointer to a @ref Data::Collection, or 0 if none can be created.
   */
  virtual Data::CollPtr collection();
  /**
   */
  virtual TQWidget* widget(TQWidget*, const char*) { return 0; }
  virtual bool canImport(int type) const;

  static bool maybeRIS(const KURL& url);

public slots:
  void slotCancel();

private:
  static void initTagMap();
  static void initTypeMap();

  Data::FieldPtr fieldByTag(const TQString& tag);
  void readURL(const KURL& url, int n, const TQDict<Data::Field>& risFields);

  Data::CollPtr m_coll;
  bool m_cancelled;

  static TQMap<TQString, TQString>* s_tagMap;
  static TQMap<TQString, TQString>* s_typeMap;
};

  } // end namespace
} // end namespace
#endif
