/***************************************************************************
    copyright            : (C) 2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_IMPORT_GRS1IMPORTER_H
#define TELLICO_IMPORT_GRS1IMPORTER_H

#include "textimporter.h"
#include "../datavectors.h"

#include <tqvariant.h>
#include <tqmap.h>
#include <tqpair.h>

namespace Tellico {
  namespace Import {

/**
 * @author Robby Stephenson
 */
class GRS1Importer : public TextImporter {
Q_OBJECT
  

public:
  GRS1Importer(const TQString& text);
  virtual ~GRS1Importer() {}

  /**
   * @return A pointer to a @ref Data::Collection, or 0 if none can be created.
   */
  virtual Data::CollPtr collection();
  /**
   */
  virtual TQWidget* widget(TQWidget*, const char*) { return 0; }
  virtual bool canImport(int type) const;

private:
  static void initTagMap();

  class TagPair : public TQPair<int, TQVariant> {
  public:
    TagPair() : TQPair<int, TQVariant>(-1, TQVariant()) {}
    TagPair(int n, const TQVariant& v) : TQPair<int, TQVariant>(n, v) {}
    TQString toString() const { return TQString::number(first) + second.toString(); }
    bool operator< (const TagPair& p) const {
      return toString() < p.toString();
    }
  };

  typedef TQMap<TagPair, TQString> TagMap;
  static TagMap* s_tagMap;
};

  } // end namespace
} // end namespace
#endif
