/***************************************************************************
    copyright            : (C) 2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_NETACCESS_H
#define TELLICO_NETACCESS_H

#include <tqobject.h>
#include <tqpixmap.h>

class KURL;
class KFileItem;
namespace TDEIO {
  class Job;
}

namespace Tellico {

class NetAccess : public TQObject {
Q_OBJECT
  

public:
  static bool download(const KURL& u, TQString& target, TQWidget* window);
  static void removeTempFile(const TQString& name);
  static TQPixmap filePreview(const KURL& fileName, int size=196);
  static TQPixmap filePreview(KFileItem* item, int size=196);

private slots:
  void slotPreview(const KFileItem* item, const TQPixmap& pix);

private:
  static TQStringList* s_tmpFiles;

  TQPixmap m_preview;
};

}
#endif
