/* This file is part of the KDE project
 * Copyright (C) 2003 Pierre Souchay <pierre@souchay.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

#ifndef __TDEFILE_OOO_H__
#define __TDEFILE_OOO_H__

#include <tdefilemetainfo.h>
#include <tqiodevice.h>
#include <tqdom.h>
#include <karchive.h>
class TQStringList;
class TQDomNode;
class TQDomElement;

class KOfficePlugin: public KFilePlugin
{
    Q_OBJECT
  

public:
    /**
     * Constructor */
    KOfficePlugin( TQObject *parent, const char *name, const TQStringList& args );
    /**
     * Read informations from files and store info in KFileMetaInfo.
     * We currently only parse meta.xml in OOo files.
     * @param info informations to modify about current file
     * @param what What kind of parsing is needed ?
     */
    virtual bool readInfo( KFileMetaInfo& info, uint what);
    /**
     * Write modified informations in meta.xml
     * @param info Informations modified
     */
    virtual bool writeInfo( const KFileMetaInfo& info) const;
    /**
     * We need a validator, for the langage
     */
    virtual TQValidator* createValidator( const TQString& mimetype,
                                         const TQString &group,
					 const TQString &key,
					 TQObject* parent,
					 const char* name) const;
private:
    bool writeTextNode(TQDomDocument & doc,
		       TQDomNode & parentNode,
		       const TQString  &nodeName,
		       const TQString  &value) const;
    KFileMimeTypeInfo::GroupInfo* userdefined;
    void addAttributeInfo(const TQDomElement & elem, KFileMetaInfoGroup & group,
		          const TQString &attributeName);
    TQIODevice* getData(KArchive &m_zip, int fileMode) const;
    bool writeMetaData(const TQString & path, const TQDomDocument &doc) const;
    TQDomDocument getMetaDocument(const TQString &path) const;
    TQDomNode getBaseNode(const TQDomDocument &doc) const;
    void makeMimeTypeInfo(const TQString& mimeType);
    TQString stringFromNode(const TQDomNode &node, const TQString &name);
    void getEditingTime(KFileMetaInfoGroup group1, const char *, TQString & txt);
    void getDateTime(KFileMetaInfoGroup group1, const char *, TQString & txt);
};

#endif
